;;; $Id: careless.scm,v 1.2 2010/01/13 22:04:59 lucier Exp lucier $ 
;;; Copyright (c) 1990-97 by Christian Queinnec. All rights reserved.

;;;                ***********************************************
;;;                    Small, Efficient and Innovative Class System
;;;                                    Meroon 
;;;                              Christian Queinnec  
;;;                    Ecole Polytechnique & INRIA--Rocquencourt
;;;                ************************************************

;;; These functions are needed for the bootstrap. CAUTION: this file
;;; must be regenerated if the structure of the primitive classes
;;; change since offsets are hardwired here. These accessors are used
;;; in safe contexts and are necessary for speed (in absence of a
;;; type-recovery analysis in define-method forms).

(define-inline (careless-Class-name class) 
  (instance-ref class 0) )
(define-inline (careless-initialize-Class-name class name) 
  (instance-set! class 0 name) )
(define-inline (careless-initialize-Class-number class cn)
  (instance-set! class 1 cn) )
(define-inline (careless-Class-fields class)
  (instance-ref class 2) )
(define-inline (careless-initialize-Class-fields class fields)
  (instance-set! class 2 fields) )
(define-inline (careless-Class-depth class) 
  (instance-ref class 3) )
(define-inline (careless-initialize-Class-depth class cn)
  (instance-set! class 3 cn) )
(define-inline (careless-Class-super-number class)
  (instance-ref class 4) )
(define-inline (careless-initialize-Class-super-number class scn)
  (instance-set! class 4 scn) )
(define-inline (careless-Class-subclass-numbers class)
  (instance-ref class 5) )
(define-inline (careless-set-Class-subclass-numbers! class lcn)
  (instance-set! class 5 lcn) )
(define-inline (careless-Class-next class)
  (instance-ref class 6) )
(define-inline (careless-set-Class-next! class cn)
  (instance-set! class 6 cn) )
(define-inline (careless-initialize-Class-allocator class a)
  (instance-set! class 7 a) )
(define-inline (careless-initialize-Class-immutable? class bool)
  (instance-set! class 8 bool) )
;;; Object has depth 0 (see genes1.scm)
(define-inline (careless-Class-super-length class)
  (fx+ 1 (careless-Class-depth class)) )
(define-inline (careless-Class-super class index)
  (if (and (fx>= index 0) (fx<= index (careless-Class-depth class)))
      (instance-ref class (fx+ 10 (fx+ 1 index)))
      (report-bad-index 'super class index) ) )
(define-inline (careless-initialize-Class-super class index cn)
  (if (and (fx>= index 0) (fx<= index (careless-Class-depth class)))
      (instance-set! class (fx+ 10
				(fx+ 1 index))
		     cn)
      (report-bad-index 'super class index) ) )
(define-inline (careless-Class-relnum class index)
  (if (and (fx>= index 0) (fx<= index (careless-Class-depth class)))
      (instance-ref class (fx+ 10
			       (fx+ 1
				    (fx+ (careless-Class-depth class)
					 index))))
      (report-bad-index 'super class index) ) )
(define-inline (careless-initialize-Class-relnum class index cn)
  (if (and (fx>= index 0) (fx<= index (careless-Class-depth class)))
      (instance-set! class (fx+ 10
				(fx+ 1
				     (fx+ (careless-Class-depth class) index)))
		     cn)
      (report-bad-index 'super class index) ) )

(define-inline (careless-Generic-name g)
  (instance-ref g 0) )
(define-inline (careless-initialize-Generic-name g name)
  (instance-set! g 0 name) )
(define-inline (careless-Generic-default g)
  (instance-ref g 1) )
(define-inline (careless-initialize-Generic-default g d)
  (instance-set! g 1 d) )
(define-inline (careless-initialize-Generic-dispatcher g d)
  (instance-set! g 3 d) )
(define-inline (careless-set-Generic-dispatcher! g d)
  (instance-set! g 3 d) )
(define-inline (careless-Generic-top-classes g)
  (instance-ref g 4) )
(define-inline (careless-initialize-Generic-top-classes g cs)
  (instance-set! g 4 cs) )

(define-inline (careless-Field-name field)
  (instance-ref field 0) )
(define-inline (careless-initialize-Field-name field name)
  (instance-set! field 0 name) )
(define-inline (careless-Field-immutable? field)
  (instance-ref field 1) )
(define-inline (careless-initialize-Field-immutable? field bool)
  (instance-set! field 1 bool) )
(define-inline (careless-Field-class-number field)
  (instance-ref field 2) )
(define-inline (careless-initialize-Field-class-number field cn)
  (instance-set! field 2 cn) )
(define-inline (careless-Field-initialized? field)
  (instance-ref field 3) )
(define-inline (careless-initialize-Field-initialized? field bool)
  (instance-set! field 3 bool) )
(define-inline (careless-Field-initializer field)
  (instance-ref field 4) )
(define-inline (careless-initialize-Field-initializer field fun)
  (instance-set! field 4 fun) )
(define-inline (careless-Field-path-length field)
  (instance-ref field 5) )
(define-inline (careless-Field-path field index)
  (instance-ref field (fx+ 5 (fx+ 1 index))) )

;(define-inline (careless-Dispatcher-method-finder d)
;  (instance-ref d 0) )
(define-inline (careless-initialize-Dispatcher-method-finder d v)
  (instance-set! d 0 v) )

(define-inline (careless-Immediate-Dispatcher-method d)
  (instance-ref d 1) )

(define-inline (careless-Global-Dispatcher-method-length d)
  (instance-ref d 1) )
(define-inline (careless-Global-Dispatcher-method d i)
  (instance-ref d (fx+ 2 i)) )
(define-inline (careless-set-Global-Dispatcher-method! d i m)
  (instance-set! d (fx+ 2 i) m) )

(define-inline (careless-Indexed-Dispatcher-class-number d)
  (instance-ref d 1) )
(define-inline (careless-set-Indexed-Dispatcher-class-number! d cn)
  (instance-set! d 1 cn) )
(define-inline (careless-Indexed-Dispatcher-class-depth d)
  (instance-ref d 2) )
(define-inline (careless-set-Indexed-Dispatcher-class-depth! d cn)
  (instance-set! d 2 cn) )
(define-inline (careless-Indexed-Dispatcher-no d)
  (instance-ref d 3) )
(define-inline (careless-set-Indexed-Dispatcher-no! d v)
  (instance-set! d 3 v) )
(define-inline (careless-Indexed-Dispatcher-method-length d)
  (instance-ref d 4) )
(define-inline (careless-Indexed-Dispatcher-method d i)
  (instance-ref d (fx+ 5 i)) )
(define-inline (careless-set-Indexed-Dispatcher-method! d i v)
  (instance-set! d (fx+ 5 i) v) )

(define-inline (careless-Subclass-Dispatcher-class-number d)
  (instance-ref d 1) )
(define-inline (careless-set-Subclass-Dispatcher-class-number! d cn)
  (instance-set! d 1 cn) )
(define-inline (careless-Subclass-Dispatcher-class-depth d)
  (instance-ref d 2) )
(define-inline (careless-set-Subclass-Dispatcher-class-depth! d cn)
  (instance-set! d 2 cn) )
(define-inline (careless-Subclass-Dispatcher-no d)
  (instance-ref d 3) )
(define-inline (careless-set-Subclass-Dispatcher-no! d v)
  (instance-set! d 3 v) )
(define-inline (careless-Subclass-Dispatcher-yes d)
  (instance-ref d 4) )
(define-inline (careless-set-Subclass-Dispatcher-yes! d v)
  (instance-set! d 4 v) )

(define-inline (careless-initialize-Linear-Dispatcher-method d m)
  (instance-set! d 2 m) )

;;; end of careless.scm
