function nflops = flops(type,A,transA,B,transB)

switch lower(type)
    case 'sum'
        nflops = double(numel(A));
    case 'mv'
        if lower(transA) == 'n'
            nflops = double(size(A,1)*(2*size(A,2)-1));
        else
            nflops = double(size(A,2)*(2*size(A,1)-1));
        end
    case 'prod'
        if lower(transA) == 'n'
            if lower(transB) == 'n'
                nflops = double(size(A,1)*(2*size(B,1)-1)*size(B,2));
            else
                nflops = double(size(A,1)*(2*size(B,2)-1)*size(B,1));
            end
        else
            if lower(transB) == 'n'
                nflops = double(size(A,2)*(2*size(B,1)-1)*size(B,2));
            else
                nflops = double(size(A,2)*(2*size(B,2)-1)*size(B,1));
            end
        end
    case 'rdiv'
        if lower(transA) == 'n'
            if strcmp(transB,'tri')
                nflops = double(size(A,1)*size(B,1)^2);
            else
                nflops = double(size(A,1)*2/3*size(B,1)^3);
            end
        else
            if strcmp(transB,'tri')
                nflops = double(size(A,2)*size(B,1)^2);
            else
                nflops = double(2*size(A,2)*size(B,1)^2+2/3*size(B,1)^3);
            end
        end
    case 'ldiv'
        if lower(transB) == 'n'
            if strcmp(transA,'tri')
                nflops = double(size(B,2)*size(A,1)^2);
            else
                nflops = double(size(B,2)*2/3*size(A,1)^3);
            end
        else
            if strcmp(transA,'tri')
                nflops = double(size(B,1)*size(A,1)^2);
            else
                nflops = double(2*size(B,1)*size(A,1)^2+2/3*size(A,1)^3);
            end
        end
    case 'chol'
        nflops = double(size(A,1)^3/3)-size(A,1)^2+size(A,1)*2/3;
end