function [x,y] = flower1d(n)

t = linspace(0,2*pi,n);
r = cos(15*t);
r(r <= 0) = 0;
x = r.*(sin(t));
y = r.*(cos(t).^(1/3));
xb = 1;
p = transpose(x+1i*y);

c = 0.7+1i*0.8;
I = abs(p-c) < xb/1.8;
J = abs(p-c) >= xb/1.75;
x = p(I);
y = p(J);
% plot(real(p),imag(p))
plot(real(x),imag(x),'r.',real(y),imag(y),'b.','markersize',10)
axis off