function [Q,R,nflops,rk] = compr(A,typ,par,opt)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Compression routine (rank-revealing QR) %%%
%%%           ver. 2018-7-17                %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% opt = 0: Dirctly based on Matlab SVD

if nnz(A) == 0 % full zero matrix
    Q = zeros(size(A,1),1);
    R = zeros(1,size(A,2));
    nflops = 0;
    rk = 1;
    return
end

if nargin < 4
    opt = 0; % default compression routine option
end

nflops = 0;

switch opt
    case 0
        [Q,D,V] = svd(A); R = D*V';
        if typ == 't'
           rk = length(find(diag(D) >= D(1,1)*par));
           Q = Q(:,1:rk); R = R(1:rk,:);
        elseif typ == 'r'
           rk = min([par,size(R)]);
           Q = Q(:,1:rk); R = R(1:rk,:);
        else
           error('The 2nd parameter must be ''t'' or ''r''')
        end
end

% fprintf('compression flops: %8.2e\n',nflops);
% maxerr(Q*R,A)