function [L,P,R,W,szu,factsize] = sif0(A,tr,m,type,par,lvl,varargin)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   Two-sided-scaling approximated Cholesky factorization
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

factsize = 0;
D = {[]}; L = {[]}; P = {[]}; B = {[]}; R = {[]}; U = {[]}; W = {[]};

N = size(A,1);
n = length(tr);
ch = child(tr);

% l(i,1:2): range of block i
l = zeros(n,2);
l(1,:) = [1 m(1)];
lt = 1; it = 1;
for i = 1:n
    if isempty(ch{i})
        l(i,:) = [lt lt+m(it)-1];
        lt = l(i,2)+1; it = it+1;
    else
        l(i,:) = [l(ch{i}(1),1) l(ch{i}(2),2)];
    end
end


for i = 1:n
%     if mod(i,100)== 0
%         disp('i=');
%         disp(i);
%     end
    ch1 = ch{i};
    if isempty(ch1)
        try
            L{i} = chol(A(l(i,1):l(i,2),l(i,1):l(i,2)),'lower');
        catch
            L{i} = chol(A(l(i,1):l(i,2),l(i,1):l(i,2))+(1e-6)*eye(l(i,2)-l(i,1)+1),'lower');
        end
        factsize = factsize + double(numel(L{i}));
        % off-diag row compression
        if i == 1
            T1 = A(l(i,1):l(i,2),l(i,2)+1:N);
            T1 = L{i}\T1;
            A(l(i,1):l(i,2),l(i,2)+1:N) = T1;
        else
            T1 = [A(1:l(i,1)-1,l(i,1):l(i,2))' A(l(i,1):l(i,2),l(i,2)+1:N)];
            T1 = L{i}\T1;
            A(l(i,1):l(i,2),1:l(i,1)-1) = T1(:,1:l(i,1)-1);
            A(l(i,1):l(i,2),l(i,2)+1:N) = T1(:,l(i,1):end);
        end
    else
        AT = A(l(ch1(2),1):l(ch1(2),2),l(ch1(1),1):l(ch1(1),2));
        [U{ch1(2)},AT,nflops1] = compr(full(AT),type,par(lvl(i)));
        [U{ch1(1)},AT,nflops1] = compr(full(AT'),type,par(lvl(i)));
        B{ch1(2)} = AT';
        %factsize = factsize + double(numel(B{ch1(2)}));
        % two children
        for k = 1:2
            sz(k,1:2) = size(U{ch1(k)});     
            [U{ch1(k)},P{ch1(k)}] = house_qr(U{ch1(k)});            
            U{ch1(k)} = U{ch1(k)}(1:sz(k,2),:);
            %factsize = factsize + double(numel(P{ch1(k)}));
            factsize = factsize + sz(k,1)*sz(k,2);
        end
        szu(ch1(1),:) = size(U{ch1(1)}); szu(ch1(2),:) = size(U{ch1(2)});
        W{i} = U{ch1(2)}*B{ch1(2)}*U{ch1(1)}';
        factsize = factsize + double(numel(W{i}));
        
        D{i} = eye(sz(2,2))-W{i}*W{i}';
        
        try
            R{i} = chol(D{i},'lower');
        catch
            %e = eigs(D{i},1,'sm');
            e = eig(D{i});
            e = abs(min(e))*2;
            fprintf('Positive definiteness issue, add %7.3e*I\n',e)
            R{i} = chol(D{i}+e*eye(size(D{i},1)),'lower');
        end
        factsize = factsize + double(numel(R{i}));        
            % root
        if i == n; break; end
        % update off-diagonal blocks
        A(l(ch1(1),1):l(ch1(1),2),l(i,2)+1:end) = house_apply_transpose(P{ch1(1)},A(l(ch1(1),1):l(ch1(1),2),l(i,2)+1:end));
        A(l(ch1(1),1):l(ch1(1),2),l(i,2)+1:end) = A([l(ch1(1),1)+sz(1,2):l(ch1(1),2) l(ch1(1),1):l(ch1(1),1)+sz(1,2)-1],l(i,2)+1:end);
        A(l(ch1(2),1):l(ch1(2),2),l(i,2)+1:end) = house_apply_transpose(P{ch1(2)},A(l(ch1(2),1):l(ch1(2),2),l(i,2)+1:end));
        S1 = A(l(ch1(1),2)-sz(1,2)+1:l(ch1(1),2),l(i,2)+1:end);
        S2 = A(l(ch1(2),1):l(ch1(2),1)+sz(2,2)-1,l(i,2)+1:end);
        A(l(ch1(2),1):l(ch1(2),1)+sz(2,2)-1,l(i,2)+1:end) = R{i}\(-W{i}*S1+S2);
        if i ~= 3 
           A(l(ch1(1),1):l(ch1(1),2),1:l(ch1(1),1)-1) = house_apply_transpose(P{ch1(1)},A(l(ch1(1),1):l(ch1(1),2),1:l(ch1(1),1)-1));
           A(l(ch1(1),1):l(ch1(1),2),1:l(ch1(1),1)-1) = A([l(ch1(1),1)+sz(1,2):l(ch1(1),2),l(ch1(1),1):l(ch1(1),1)+sz(1,2)-1],1:l(ch1(1),1)-1);
           A(l(ch1(2),1):l(ch1(2),2),1:l(ch1(1),1)-1) = house_apply_transpose(P{ch1(2)},A(l(ch1(2),1):l(ch1(2),2),1:l(ch1(1),1)-1));
           S1 = A(l(ch1(1),2)-sz(1,2)+1:l(ch1(1),2),1:l(ch1(1),1)-1);
           S2 = A(l(ch1(2),1):l(ch1(2),1)+sz(2,2)-1,1:l(ch1(1),1)-1);
           A(l(ch1(2),1):l(ch1(2),1)+sz(2,2)-1,1:l(ch1(1),1)-1) = R{i}\(-W{i}*S1+S2);    
        end 
    end
    
end 
        