%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%  test/driver routine
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%% Data and parameters
n = 3200;
A = diag((1:n).^(1/4))*toeplitz(2*pi/2./(4*2^2+(0:n-1).^2))*diag((1:n).^(1/4));

n = size(A,1);
x0 = ones(n,1);
b = A*x0; bn = norm(b);
m0 = 5; %  leaf block row size
r0 = m0;
err = 1e-12;

fprintf('n = %d, m0 = %d, r0 = %d\n',n,m0,r0);

[tr,m] = npart(n,m0); % binary tree; partition sequence of n
lvl = findlevel(tr);
par = r0*ones(1,max(lvl));

%%% Preconditioning

%% Version SIF0

% Generating preconditioner
t00 = clock;
[L0,P0,R0,W0,sz0,mem2] = sif0(A,tr,m,'r',par,lvl,[]);
t01 = etime(clock,t00);
fprintf('Storage: %7.2e\n',mem2);

% PCG
t00 = clock;
[x0,f0,rr0,iter0,rv0] = pcg(A,b,err,800,@(b)sif0s(L0,P0,R0,W0,n,tr,m,sz0,b,'n'),@(b)sif0s(L0,P0,R0,W0,n,tr,m,sz0,b,'t'));
t03 = etime(clock,t00);
fprintf('iter: %4d, err: %7.2e; time const: %7.2e, iter: %7.2e\n\n',iter0,rr0,t01,t03);