#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#define C 3.248367785
#define scale 100
#define halfscale 50
#define Pi 3.1415926

float integrand(float x, float theta1)
{ float t1,t2,t3,t5,t6,t7,t9,t11,t12;
 float t14,t15,t17;
 
 t1 = cos(theta1);      
 t2 = x+t1;
 t3 = t2*t2;
 t5 = sqrt(1.0-t3);
 t6 = sin(theta1);
 t7 = t6*t6;
 t9 = acos(t2);
 t11 = cos(theta1/2.0-t9/2.0);
 t12 = t11*t11;
 t14 = cos(theta1/2.0+t9/2.0);
 t15 = t14*t14;
 t17 = t15*t12*t7*t5;
 return t17;
}

float psi1(float x)
{int i;
 float sum = 0;
 float limit, delta;
 float PI = 2*acos(0);
 int mesh = 500; 

 limit = PI-acos(x+1);
 delta = limit/mesh;

 for(i=0; i<mesh; i++)
   sum += integrand(x,delta*i);
 return sum*delta;
}

float psi(float x)
{return C*psi1(-fabs(x));}

float intpsi(int i)
{int j;
 float sum =0, x0, delta;
 int mesh = 500;

 delta = 4/((float) mesh*scale);
 x0 = -2 + 4*i/((float) scale);
 for(j=0;j<mesh; j++)
   sum += psi(x0 +j*delta);
 return sum*delta;
} 




main()
{ int  i;

 



 printf("[ ");
 for(i=0; i< 99;i++)
   {printf("%f,", intpsi(i));
   if(((i+1)%5 == 0)) printf("\n");}
 printf(" %f ]\n", intpsi(99));

 

 exit(0);
}















