***** MODELO DE GASSMANN *****
* El codigo calcula densidades y modulos elasticos. 
* Los modulos viscoelasticos son funcion de la frecuencia
*
* Los archivos de salida dan:
*
*     bulk_density.mat   material y densidad
*
*     p_modulus.freq     frec., parte real e imaginaria de modulo de onda plana
*                        para cada material
* 
*     ps_modulus.freq    frec., parte real e imaginaria de modulo de corte 
*                        para cada material
*
      implicit none
c Comienza declaracion de variables
       integer nm,ii
       integer nmat,nfrec,jw1,jw2
       real*8 pi,twopi,fmax,omega,frec,deltaf
       real*8 vp_matrix,vs_matrix,vp1g,vsg,xinv_q1_efw,xinv_qs_efw
       real*8 xks_l,ros_l,xkm_l,xmum_l,fi_l
       real*8 deltp_l,delts_l,fq1_l,fq2_l,xkf_l,rof_l,xmr_l
       real*8 ro_l,qp_l,constp_l,qs_l,consts_l,tau1_l,tau2_l
       real*8 fnfrec,fjw,aux1,aux2,aux3,aux4
       real*8 aap,bbp,aas,bbs,alpha,xkav,xkc,hc
       real*8 delt_kav_l,dd
       real*8 c1w,csw,aten1,atens
       complex*16 aim,p1,p3,xmuw_l
       complex*16 xkcw,hcw
c Finaliza declaracion de variables
c
c Abre unidad de entrada
c
c      open(unit=5,file='inp',status='unknown')
c
c Abre unidades de salida
c
c      open(unit=6,file='output',status='unknown')
      open(unit=8,file='p_modulus.freq',status='unknown')
      open(unit=9,file='s_modulus.freq',status='unknown')      
      open(unit=11,file='bulk_density.mat',status='unknown')
      open(unit=21,file='v33_quintuco.freq',status='unknown')
      open(unit=31,file='v55_quintuco.freq',status='unknown')
      open(unit=22,file='v33_tordillo.freq',status='unknown')
      open(unit=32,file='v55_tordillo.freq',status='unknown')
      open(unit=23,file='v33_VM1.freq',status='unknown')
      open(unit=33,file='v55_VM1.freq',status='unknown') 
      open(unit=43,file='v33_VM2.freq',status='unknown')
      open(unit=53,file='v55_VM2.freq',status='unknown')    
      
c
c Calcula pi, 2*pi y numero imaginario i
c         
      pi=4.d0*datan(1.d0)
      twopi = 2.d0*pi      
      aim=dcmplx(0.d0,1.d0)
c
c Lectura de archivo de entrada (inp) y escritura en archivo de salida (output) 
c
       read(5,*) nmat
       write(6,*) 'Materiales totales = ',nmat
       
       do nm=1,nmat
       
       write(8,77)nm       
       write(9,77)nm       
       write(11,77)nm   
77     format(i5)         

         write(6,*)' ********************************************'
	 write(6,*)	 
         write(6,*)' material numero =   ',nm
	 write(6,*)
         write(6,*)' ********************************************'	 
	 write(6,*)           
c      
c Medio de Gassmann Viscoelastico 
c   
         write(6,*) 'Gassmann'
c
c Variables descriptas en archivo de entrada inp
c 	
       read(5,*)fmax
       read(5,*)nfrec
       read(5,*)xks_l
       read(5,*)ros_l
       read(5,*)xkm_l
       read(5,*)xmum_l
       read(5,*)fi_l
       read(5,*)deltp_l
       read(5,*)delts_l
       read(5,*)delt_kav_l
       read(5,*)fq1_l
       read(5,*)fq2_l
       read(5,*)xkf_l
       read(5,*)rof_l
     
	 write(6,*)
	 write(6,*) 'frecuencia maxima  fmax (Hz) = ',fmax
	 write(6,*)    
         write(6,*)
	 write(6,*) 'Propiedades de los granos solidos'
	 write(6,*)
	 write(6,*) 'modulo bulk de los granos solidos xks  = ',
     1               xks_l*1.d-10,' GPa'
         write(6,*)	 	  
	 write(6,*) 'densidad de los granos solidos ros = ',ros_l,
     1             ' gr/cm^3'
        write(6,*)
        write(6,*)
        write(6,*) 'Propiedades de la matriz solida'
        write(6,*)
	write(6,*) 'modulo bulk de la matriz seca = ',
     1              xkm_l*1.d-10,' GPa '
        write(6,*)	
	write(6,*) 'modulo de corte de la matriz seca = ',
     1              xmum_l*1.d-10,' GPa ' 
        write(6,*)	
        write(6,*)	 
        write(6,*) 'porosity fi_l = ',fi_l
        write(6,*)
        write(6,*)
      write(6,*) 'Parametros para viscoelasticidad'
      write(6,*)     
      write(6,*) 'deltp_l = ',deltp_l
      write(6,*)
      write(6,*) 'delts_l = ',delts_l
      write(6,*)	   	  		
      write(6,*) 'delt_kav_l = ',delt_kav_l
      write(6,*)	 
      write(6,*) 'fq1 (Hz) = ',fq1_l
      write(6,*) 'fq2 (Hz) = ',fq2_l 
      write(6,*)
      write(6,*)
      write(6,*) 'Velocidades a partir de modulos de matriz seca'
      write(6,*) 
	      
       xmr_l=xkm_l+4.d0*xmum_l/3.d0
c       write(6,*)
c       write(6,*) 'xmr_l (GPa) = ',xmr_l*1.d-10 
             
      vp_matrix = dsqrt( xmr_l/(ros_l*(1.d0-fi_l)))
      vs_matrix = dsqrt(xmum_l/(ros_l*(1.d0-fi_l)))       
       
        write(6,*) 'velocidad P-wave (seca) = ',vp_matrix*1.d-2,' m/s'
        write(6,*)
        write(6,*) 'velocidad S-wave Seca) = ',vs_matrix*1.d-2,' m/s'
         write(6,*)
         write(6,*)
 	 write(6,*) 'Propiedades del fluido'
	 write(6,*)
	 write(6,*) 'modulo bulk del fluido xkf_l = ',xkf_l*1.d-10,
     1             ' GPa'
         write(6,*)
	 write(6,*) 'densidad del fluido rof_l = ',rof_l,' gr/cm^3'
         write(6,*)	
         write(6,*)
c
c Calcula modulo undrained (closed) xkc del material saturado 
c mediante modelo de Gassmann
c 
	alpha = 1.d0 - xkm_l/xks_l
			
	xkav = (alpha - fi_l)/xks_l + fi_l/xkf_l
	
	xkav = 1.d0/xkav
	
	dd = alpha* xkav
	
	xkc = xkm_l + alpha**2 *xkav
		 
        hc=xkc+(4.d0/3.d0)*xmum_l	
	
        write(6,*) 'Propiedades del material saturado'
        write(6,*)	
	write(6,*) 'modulo bulk undrained xkc = ',xkc*1.d-10,' GPA'
        write(6,*)	
	write(6,*) 'modulus de corte xmum = ',xmum_l*1.d-10,' GPA'     
        write(6,*)	
	write(6,*) 'modulo de onda plana hc = ',hc*1.d-10,' GPA'
        write(6,*)	
	write(6,*) 'coeficiente xkav = ',xkav*1.d-10,' GPA'
	write(6,*)	
	write(6,*) 'coeficiente alpha = ',alpha
	write(6,*)
c
c Calculo de la densidad
c
       ro_l=(1.d0-fi_l)*ros_l+fi_l*rof_l
            
	write(6,*)
	write(6,*) 'densidad bulk ro_l = ',ro_l,' gr/cm^3'
	write(6,*)	

        vp1g=dsqrt(hc/ro_l)
	vsg = dsqrt(xmum_l/ro_l)       
      
       write(6,*)                    
       write(6,*) 'velocidad de Gassmanns P-wave V1G = ',
     1             vp1g*1.d-2,' m/s' 
       write(6,*)	       
       write(6,*) 'velocidad de Gassmann S-wave VSG = ',
     1             vsg*1.d-2,' m/s'       
c         
c Escribe densidad bulk  ro  para cada material in 11. Unidad  gr/m^3
c       
       write(11,78) ro_l*1.d+6
78     format(e20.12)

        write(6,*)      
        write(6,*) 'ro_l (gr/cm^3) = ',ro_l
        write(6,*)
        write(6,*)
c
c Atenuacion usando modelo de Liu, Anderson y Kanamori
c	
          if(deltp_l.gt.0.d0) then
      qp_l =pi/deltp_l 
      constp_l=2.d0/(qp_l*pi)      
          else
      constp_l=0.d0
          endif 

          if(delts_l.gt.0.d0) then
      qs_l =pi/delts_l
      consts_l=2.d0/(qs_l*pi)       
          else
      consts_l=0.d0
          endif 
	  
      tau1_l=1.d0/(twopi*fq1_l)
      tau2_l=1.d0/(twopi*fq2_l)

               write(6,*) 'qs_l consts_l = ',qs_l,consts_l
               write(6,*) 'qp_l constp_l = ',qp_l,constp_l
               write(6,*) 'tau1_l, tau2_l = ',tau1_l,tau2_l 
    
       fnfrec = float(nfrec)
       deltaf = fmax/fnfrec
       jw2 = int(fmax/deltaf)

       jw1=1
       write(6,*) 'deltaf Liu (Hz)',deltaf, ' jw2 = ',jw2
       write(6,*) 
c
c Loop en frecuencia
c 
       do ii=jw2,jw1,-1
       
       fjw=ii
       fjw=fjw-1.d0+.5d0
       frec=fjw*deltaf
       
       write(6,98667)ii,frec
98667  format(/1x,'frequency number : ',i5,
     1            ' frequency :        ',e15.5,' Hz')
       write(6,*) 
       
       omega=2.d0*pi*frec
                     
      aux1=1.d0+(omega*tau1_l)**2
      aux2=1.d0+(omega*tau2_l)**2
      aux3=omega*(tau1_l-tau2_l)
      aux4=1.d0+ (omega*tau1_l)*(omega*tau2_l)

      aap=1.d0-.5d0*constp_l*dlog(aux1/aux2)
      bbp=constp_l*datan(aux3/aux4)
      
      aas=1.d0-.5d0*consts_l*dlog(aux1/aux2)
      bbs=consts_l*datan(aux3/aux4)
 
       xmuw_l = xmum_l/(aas - aim*bbs)

       xkcw=xkc/(aap-aim*bbp)
       
      hcw= xkcw+(4.d0/3.d0)*xmuw_l 
      
c       write(6,*)
c       write(6,*)' real(xkcw)  : ',dreal(xkcw)*1.d-10, ' GPa'
c       write(6,*)       
c       write(6,*)' imag(xkcw)  : ',dimag(xkcw)*1.d-10, ' GPa'
c       write(6,*)                  
c       write(6,*)' real(xmuw_l) : ',dreal(xmuw_l)*1.d-10, ' GPa'
c       write(6,*)       
c       write(6,*)' imag(xmuw_l) : ',dimag(xmuw_l)*1.d-10, ' GPa'
c       write(6,*) 
c
c Calcula numero de onda complejo para ondas compresional y de shear
c
	p1 = (omega**2*ro_l)/hcw
	p1 = cdsqrt(p1)
	
        c1w   = omega/dreal(p1)
        aten1=-8.686d0*2.d0*pi*dimag(p1)/dreal(p1)

	p3 = (omega**2*ro_l)/xmuw_l
	p3 = cdsqrt(p3)
	
        csw   = omega/dreal(p3)
        atens=-8.686d0*2.d0*pi*dimag(p3)/dreal(p3)

       write(6,*) 'Velocidad P-wave de Gassmann c1w = ',c1w*1.d-2,' m/s'
       write(6,*)
       write(6,*) 'Velocidad S-wave de Gassmann csw = ',csw*1.d-2,' m/s'                 
       write(6,*)	
       write(6,*) 'Atenuacion onda P de Gassmann = ',aten1,' DB/Hz-sec'
       write(6,*)
       write(6,*) 'Atenuacion onda P de Gassmann = ',atens,' DB/Hz-sec'
       write(6,*)
       	
        xinv_q1_efw = dimag(hcw)/dreal(hcw)	
        xinv_qs_efw = dimag(xmuw_l)/dreal(xmuw_l)
c         
c Escribe frecuencia (en KHz), parte real y parte imaginaria de los modulos
c
 	write(8,698)frec*1.d-3,dreal(hcw)*1.d-4,dimag(hcw)*1.d-4
	write(9,698)frec*1.d-3,dreal(xmuw_l)*1.d-4,dimag(xmuw_l)*1.d-4	      
698     format(3e20.12)

         if (nm.eq.1) then
             write(21,*)frec,c1w*1.d-2
             write(31,*)frec,csw*1.d-2
         end if
         
         if (nm.eq.2) then
             write(22,*)frec,c1w*1.d-2
             write(32,*)frec,csw*1.d-2
         end if
        
        if (nm.eq.3) then
             write(23,*)frec,c1w*1.d-2
             write(33,*)frec,csw*1.d-2
         end if
        if (nm.eq.4) then
             write(43,*)frec,c1w*1.d-2
             write(53,*)frec,csw*1.d-2
         end if
        enddo        ! fin del loop en frecuencia
      
        enddo        ! fin del loop para los materiales

      stop
      end


