c
c  This code ( ddanelas.f)  solves  the  2-d elastic wave equation
c
c  - * omega**2 * U^(x,omega)
c
c           - div(sigma( U^ (x,omega)) = f^(x,omega)  , x in R ,
c
c  with  the absorbing b.c.
c
c     - sigma (U^ (x,omega). nu(x) = i * omega * D (x,omega)* U^(x,omega)
c
c  where
c
c   sigma = stress tensor
c
c   nu =  unit outward normal  to the bry of  R ,
c
c   R : a rectangular domain.
c
c
c
c  The equation  is solved in the space-frequency domain using
c
c  an iterative procedure with the fluxes as Lagrange multipliers.
c

      include 'sizes_v16'
c      parameter(mnx=201 ,mny=201,mlsour=600,mnmat=20)
c      parameter(mngx=203, mngy=203)
c      parameter(ntstep=5000,mnrec=150,mtsnap=10)

      implicit double precision (a-h,o-z)
      integer prfirst
      complex*16 fu1(mlsour,mnrec),fu2(mlsour,mnrec),
     1           fdivu(mlsour,mnrec)
      dimension tpic1(mnx*mny*mtsnap),uu(ntstep),tpic2(mnx*mny*mtsnap)

      dimension  ros(mnmat),xkr(mnmat),xmur(mnmat),deltp(mnmat)
      real*8    xksc(mnmat)
      dimension  delts(mnmat),fq1(mnmat),fq2(mnmat),ve(mnmat)
      dimension  qp(mnmat),xmr(mnmat),constp(mnmat),consts(mnmat)
      dimension  tau1(mnmat),tau2(mnmat)
      dimension  rho(0:mnx+1,0:mny+1)
      complex*16  xln(0:mnx+1,0:mny+1)
      complex*16  xmu(0:mnx+1,0:mny+1)
      complex*16  alfall(0:mny+1),alfarr(0:mny+1)
      complex*16  alfabb(0:mnx+1),alfatt(0:mnx+1)
      complex*16  betall(0:mny+1),betarr(0:mny+1)
      complex*16  betabb(0:mnx+1),betatt(0:mnx+1)
      complex*16  xmuw(mnmat),xlanw(mnmat)
      dimension  source(ntstep),xnod(mnx+1),ynod(mny+1)
      dimension  rx(mnrec),ry(mnrec),irecid(mnrec)
      dimension itsnap(10),tsnap(10)
      dimension  wsnap(10),iwsnap(10),irx(mnrec),iry(mnrec)
      dimension  suml(2),swork(2)
      complex*16 x(mlsour),fsour(mlsour)
      complex*16 xmw(mnmat),avsol1,avsol2
      dimension  deltal(mnx),deltar(mnx),deltat(mny),deltab(mny)
      integer blockid,vblockid,blockty
      common/a1/ncontrol,blockid,vblockid(2),blockty,nsx,nsy
      double precision start_time, end_time, diff_time
      complex*16 xkw(mnmat),xkcw(mnmat),xkscw,qqc
      dimension fi(mnmat),rof(mnmat),xkf(mnmat),qs(mnmat)
c
c   Vectors for the absorbing B.C.
c
c
c  Iteration  matrix coefficients  beta
c
      complex*16 beta11l(0:mnx+1,0:mny+1),beta11r(0:mnx+1,0:mny+1),
     1           beta11b(0:mnx+1,0:mny+1)
      complex*16 beta11t(0:mnx+1,0:mny+1)
      complex*16 beta22l(0:mnx+1,0:mny+1),beta22r(0:mnx+1,0:mny+1),
     1           beta22b(0:mnx+1,0:mny+1)
      complex*16 beta22t(0:mnx+1,0:mny+1)
c
c    Solutions ubl , utl , ubr and utr   at iterations   n and n+1
c
      complex*16 u1ln(0:mnx+1,0:mny+1),u1tn(0:mnx+1,0:mny+1),
     1           u1bn(0:mnx+1,0:mny+1)
      complex*16 u1rn(0:mnx+1,0:mny+1)
      complex*16 u1lnp1(0:mnx+1,0:mny+1),u1tnp1(0:mnx+1,0:mny+1),
     1           u1bnp1(0:mnx+1,0:mny+1)
      complex*16 u1rnp1(0:mnx+1,0:mny+1)
c
      complex*16 u2ln(0:mnx+1,0:mny+1),u2tn(0:mnx+1,0:mny+1),
     1           u2bn(0:mnx+1,0:mny+1)
      complex*16 u2rn(0:mnx+1,0:mny+1)
      complex*16 u2lnp1(0:mnx+1,0:mny+1),u2tnp1(0:mnx+1,0:mny+1),
     1           u2bnp1(0:mnx+1,0:mny+1)
      complex*16 u2rnp1(0:mnx+1,0:mny+1)
c   Lagrange  multipliers  parameters  laglb, laglt , lagrb, , lagrt ,
c                                      lagbl, lagbr , lagtl, , lagrtr
c     at iterations  n and  n+1
c
c
      complex*16 lag1ln(0:mnx+1,0:mny+1),lag1tn(0:mnx+1,0:mny+1),
     1           lag1bn(0:mnx+1,0:mny+1),lag1rn(0:mnx+1,0:mny+1),
     1           lag1lnp1(0:mnx+1,0:mny+1),lag1tnp1(0:mnx+1,0:mny+1),
     1           lag1bnp1(0:mnx+1,0:mny+1),lag1rnp1(0:mnx+1,0:mny+1)
c
      complex*16 lag2ln(0:mnx+1,0:mny+1),lag2tn(0:mnx+1,0:mny+1),
     1           lag2bn(0:mnx+1,0:mny+1),lag2rn(0:mnx+1,0:mny+1),
     1           lag2lnp1(0:mnx+1,0:mny+1),lag2tnp1(0:mnx+1,0:mny+1),
     1           lag2bnp1(0:mnx+1,0:mny+1),lag2rnp1(0:mnx+1,0:mny+1)

c     matrices for the factorization of each 8x8 system
c
       complex*16 xld(6*mnx+2,mny),xld1(6*mnx+1,mny),xld2(6*mnx,mny),
     1        xld3(6*mnx-1,mny),xld4(6*mnx-2,mny),xld5(6*mnx-3,mny),
     1           xld6(6*mnx-4,mny),xld7(6*mnx-5,mny),
     1           u1(6*mnx+1,mny),u2(6*mnx,mny),u3(6*mnx-1,mny),
     1           u4(6*mnx-2,mny),u5(6*mnx-3,mny),u6(6*mnx-4,mny),
     1           u7(6*mnx-5,mny)
      dimension ngnod(mnx,8)
c
c  Global matrix matnum 
c 
c  matnum : integer matrix containing  the material type number at
c            each grid block in the global mesh
c
      real*8 rhob(mnmat),rob,auxxx
      dimension matnum(0:mngx+1,0:mngy+1)
c Cambio Juan
      
      complex*16 vp_c,vs_c
      complex*16 p_modulus(mnmat,mlsour),s_modulus(mnmat,mlsour)
       integer mat
      
      open(unit=1,file='p_modulus.freq',status='old')
      open(unit=2,file='s_modulus.freq',status='old') 
      open(unit=7,file='bulk_density.mat',status='old') 
      open(unit=10,file='vp.freq',status='unknown')
      open(unit=11,file='inv_qp.freq',status='unknown')      
      open(unit=12,file='vs.freq',status='unknown')
      open(unit=13,file='inv_qs.freq',status='unknown')           
      open(unit=14,file='iter.freq',status='unknown')                
      open(unit=98,file='vx_traces.su',status='unknown')             
      open(unit=99,file='vz_traces.su',status='unknown')    
      open(unit=78,file='lambda_gnu',status='unknown') 
      open(unit=88,file='mu_gnu',status='unknown')  
      open(unit=68,file='vp33_gnu',status='unknown')  
       open(unit=20,file='source',status='unknown') 
       open(unit=21,file='spectrum',status='unknown') 
       open(unit=23,file='filtered_source',status='unknown') 
       open(unit=22,file='filtered_spectrum',status='unknown') 
c     end dimension statements
c
c      TMP - PARALLEL CODE
c       open(5,file='inp',form='formatted',
c     1      status='new')
c
c   Reads input data, computes source in the time and
c   frequency domain
c
c      start_time = dclock()
      prfirst=1

        t0 = timer()
      twopi = 6.28318530717958d0
      pi = twopi*.5d0
      aim=dcmplx(0.d0,1.d0)
c     Set processor id

c     TMP - SERIAL CODE
c      blockid=mynode()
       blockid=0

       call      readata(keyqua,npf,key,nmat,xsize,ysize,
     1                   ve,constp,consts,tau1,tau2,
     1                   freq,w0,alfa,stime,xnod,ynod,nx,ny,h,dt,nt,
     1                   ntsnap,itsnap,hover6,
     1                   f1,f2,f3,f4,psi,width,ts,totpul,lpulse,
     1                   source,fny,delf,delw,if1,if2,if3,if4,jw1,jw2,
     1                   matnum,xsou,ysou,jsou,ksou,
     1                   kdel,tmute,ntmute,tsnap,nrec,
     1                   nwsnap,wsnap,iwsnap,maxiter,reduc,x,fsour,
     1                   ros,xkr,xmur,xmr,deltp,delts,qp,fq1,fq2,rho,
     1                   rx,ry,irx,iry,nsize,isourid,hpx,hpy,ngx,ngy,
     1                   maxlow,jwlow,irecid,
     1                   fi,rof,qs,qpg,xkf,constg,xksc,numatdry)
     


              
               do 20 j=1,nx
           if(j.eq.1) then
            ngnod(j,1) = 4*j-3
            ngnod(j,2) = 4*j-2
            ngnod(j,3) = 4*j-1
            ngnod(j,4) = 4*j
            ngnod(j,5) = 4*j+1
            ngnod(j,6) = 4*j+2
            ngnod(j,7) = 4*j+3
            ngnod(j,8) = 4*j+4
           else
            ngnod(j,1) = 6*j-5
            ngnod(j,2) = 6*j-4
            ngnod(j,3) = 6*j-3
            ngnod(j,4) = 6*j-2
            ngnod(j,5) = 6*j-1
            ngnod(j,6) = 6*j
            ngnod(j,7) = 6*j+1
            ngnod(j,8) = 6*j+2
           endif
20            continue

              do 1002  j=0,nx+1
               do 1002   k=0,ny+1
            u1ln(j,k) = dcmplx(0.d0,0.d0)
            u1tn(j,k) = dcmplx(0.d0,0.d0)
            u1bn(j,k) = dcmplx(0.d0,0.d0)
            u1rn(j,k) = dcmplx(0.d0,0.d0)

            u2ln(j,k) = dcmplx(0.d0,0.d0)
            u2tn(j,k) = dcmplx(0.d0,0.d0)
            u2bn(j,k) = dcmplx(0.d0,0.d0)
            u2rn(j,k) = dcmplx(0.d0,0.d0)

            lag1ln(j,k) = dcmplx(0.d0,0.d0)
            lag1bn(j,k) = dcmplx(0.d0,0.d0)

            lag2ln(j,k) = dcmplx(0.d0,0.d0)
            lag2bn(j,k) = dcmplx(0.d0,0.d0)
1002        continue

c      if(blockid.eq.0) then
c       open(unit=61,file='/usr/share/scratch7/tira/r1trace',
c     1 status='unknown')
c       endif
c      if(blockid.eq.nsx-1) then
c       open(unit=62,file='/usr/share/scratch7/tira/r2trace',
c     1 status='unknown')
c        endif
c      if(blockid.eq.nsx*nsy-1) then
c       open(unit=63,file='/usr/share/scratch7/tira/r3trace',
c     1 status='unknown')
c       endif

c        if(blockid.eq.nsx*(nsy-1))then
c       open(unit=31,file='/usr/share/scratch7/tira/for31.p15',
c     1 status='unknown')
c       endif
c        if(blockid.eq.nsx-1)then
c       open(unit=32,file='/usr/share/scratch7/tira/for32.p15',
c     1 status='unknown')
c       endif 

c       if(blockid.eq.ncontrol) then

c       open(unit=33,file='/usr/share/scratch7/tira/ubl',
c     1 status='unknown')
c       open(unit=34,file='/usr/share/scratch7/tira/ubr',
c     1 status='unknown')
c       open(unit=35,file='/usr/share/scratch7/tira/labl',
c     1 status='unknown')
c       open(unit=36,file='/usr/share/scratch7/tira/labr',
c     1 status='unknown')
c       open(unit=40,file='/usr/share/scratch7/tira/RHO',
c     1 status='unknown')
c        endif

c      Set subdomain types

       vblockid(1) = mod(blockid,nsx)
       vblockid(2) = blockid/nsx

c      Set subdomain type  in variable blockty of common /a1

       call subtype
c
c  sets delta  vectors accoeding to the subdomain type  blockty
c 

       call setdelta(nx,ny,deltal,deltar,deltat,deltab)

c
c   sets  local values for the density rho in each  block (processor)
c
c       call   setrho(h,rho,nx,ny,matnum,ros,hpx,hpy,
c     1                    fi,rof,numatdry)

* Cambio Juan

* reads complex moduli for each material and frequency



             do 333  i=1,nmat
	     
	read(1,888)mat
	


	read(2,888)mat


	
        read(7,888)nn

	
	read(7,55)rhob(i)
     

55      format(e20.12)		
888     format(i5)


            do 334 jw = jw2,jw1,-1
	    	    
           read(1,256)fr,p_real,p_imag

      
	   
           p_modulus(i,jw)=dcmplx(p_real,p_imag)

    
           read(2,256)fr,s_real,s_imag
    
           s_modulus(i,jw)=dcmplx(s_real,s_imag)
	   
256     format(3e20.12)			

334        continue
	
333        continue
c
c    main loop  in  frequency
c
c    be careful, is only for a test
c
c               jw1 = iwsnap(2)
c               jw2 = iwsnap(2)
                
c               jw1 = jw2-2 
c              jw1 = jw2
c   ********************************************
c  ESTE ES COMIENZO  MAIN LOOP EN FRECUENCIA
c   ****************************************************


               write(6,2345)jw1,jw2
2345        format(/1x,' jw1 , jw2  in main = ',i5,4x,i5)
         i=1
c	write(85,888)i
c	write(87,888)i	
c	write(88,888)i
c	write(90,888)i
c	write(80,888)i
c	write(81,888)i	
             
	      	
             do 3000 jw = jw2,jw1,-1
            ! do 3000 jw = jw2,jw2	    
	    
c            write(99,*)'Frecuencia ',jw
c c           close(99)
               
c
c
c     sets  current angular frequency  omega  to compute the solution
c
c
         if(keyqua.eq.1)then
        fjw=jw
       fjw=fjw-1.d0
       fr=fjw*delf
       omega=fr*twopi
          endif
            if(keyqua.eq.2)then
       fjw=jw
       fjw=fjw-1.d0+.5d0
       fr=fjw*delf
       omega=fr*twopi
             endif
c
c  be careful is only a test , delete
c
c           fsour(jw) = dcmplx(1.d+10,1.d+10)

      if(blockid.eq.ncontrol) then
            write(6,128)jw,fr
128        format(/1x,' frequency number ',i5,' frequency : ',e20.8)

       write(6,88666)jw,dreal(fsour(jw)),dimag(fsour(jw))
88666  format(1x,'jw  real sour, imag sour =',i7,2x,e15.5,2x,e15.5)
       endif

c
c   loop over the local grid  to obtain material properties for
c  the current  processor ( block)
c
       do 2462 k=0,ny+1

         do 2462 j=0,nx+1
c
c  computes Global position  coordinate in the  x-direction 
c
          posx = vblockid(1)*hpx + (j-1)*h +.5d0*h
c
c  computes Global position  coordinate in the  y-direction
c
          posy = ((nsy-1)-vblockid(2))*hpy+ (k-1)*h + 0.5d0*h

	  auxx = posx/h +1.d0
          auxy = posy/h +1.d0

	  indgeox = auxx
          indgeoy = auxy


       i = matnum(indgeox,indgeoy)
       
c Cambio Juan!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*************************************************************************
***********************************************************************
	   
             
	xmw(i)   = p_modulus(i,jw)
	xmuw(i)  = s_modulus(i,jw)
	
        xlanw(i)=xmw(i) - 2.d0*xmuw(i)
	
        xmu(j,k)= xmuw(i)
        xln(j,k)= xlanw(i)	 
        rho(j,k) = rhob(i)		       
 

         
c Cambio Juan!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
*************************************************************************
   
c	 if(i.le.numatdry) then
c          rob = ros(i)
c          else
c Cambio german!
c          rob=ros(i)+fi(i)*rof(i)
c          endif
	  
	  rob = rho(j,k)
	  
c          rob = 0.202270000000E+07
	  
c       xmrw=dreal(xlanw(i)+2.d0*xmuw(i))
c       xmiw=dimag(xlanw(i)+2.d0*xmuw(i))

       alpha = 1.d0 - xkr(i)/xksc(i)

       xkav = (alpha - fi(i))/xksc(i) + fi(i)/xkf(i)
       xkav = 1.d0/xkav
       

       xkc = xkr(i) + alpha**2 * xkav       
       
       
c   uses Gassmann's P-wave veloc. for the Boundary Condition to make it freq.
*  independent
       
       ccrw  = dsqrt(xkc/rho(j,k))
       ccsrw = dsqrt(xmur(i)/rho(j,k))





       vp_c=cdsqrt(xmw(i)/rob)
       vp=1.d0/(dreal(1.d0/vp_c))
       
       
       xinv_qp=dimag(vp_c**2)/dreal(vp_c**2)

c       xqp = 1.d0/xinv_qp
             
       vs_c=cdsqrt(xmuw(i)/rob)
       vs=1.d0/(dreal(1.d0/vs_c)) 
             
       xinv_qs=dimag(vs_c**2)/dreal(vs_c**2)
       
       if(vp.lt.0.d0)stop 1
       if(vs.lt.0.d0)stop 2 
       if(xinv_qp.lt.0.d0)stop 3
       if(xinv_qs.lt.0.d0)stop 4             
       
       
       
       
c       xqs = 1.d0/xinv_qs              
c       ccrw  =  vp
c       ccsrw = vs
       if(j.eq.nx/2.and.k.eq.nx/2)then
       write(10,66)dlog10(fr*1.d+3),vp
       write(11,66)dlog10(fr*1.d+3),xinv_qp 
       write(12,66)dlog10(fr*1.d+3),vs
       write(13,66)dlog10(fr*1.d+3),xinv_qs
       endif              
66     format(2e15.6)
********************************************************      
c
c  computes vectors alfal,  etc  for the absorbing B.C.
c
        if(j.eq.1)alfall(k) = dcmplx(ccrw,0.d0)
        if(j.eq.nx)alfarr(k) = dcmplx(ccrw,0.d0)
        if(k.eq.1)alfabb(j) = dcmplx(ccrw,0.d0)
        if(k.eq.ny)alfatt(j) = dcmplx(ccrw,0.d0) 
        if(j.eq.1)betall(k) = dcmplx(ccsrw,0.d0)
        if(j.eq.nx)betarr(k) = dcmplx(ccsrw,0.d0)
        if(k.eq.1)betabb(j) = dcmplx(ccsrw,0.d0)
        if(k.eq.ny)betatt(j) = dcmplx(ccsrw,0.d0) 

2462   continue



          do  k=1,ny

         do  j=1,nx
        
         if (jw.eq.jw2) then
         write(78,*)j,k,dreal(xln(j,k))/1.d9
         write(88,*)j,k,dreal(xmu(j,k))/1.d9
         write(68,*)j,k,dreal(xln(j,k)+2.d0*xmu(j,k))/rho(j,k)
         end if
         
            enddo
            enddo
    
    
!       stop 3435

c    sets  iteration parameters  betal ,betar,betat,betab
c
      call  inbeta(nx,ny,h,omega,rho,beta11l,beta11r,beta11t,
     1             beta11b,beta22l,beta22r,beta22t,beta22b,
     1             xln,xmu,jw)
c
c  Computes complex coefficient  A = xa(j)  (A = a + i b in the notes)
c  using formulas corresponding to the Liu model with continuous spectrum
c  of relaxation times
c
               do 1102 k=1,ny
       call  coeflu(k,nx,ny,jw,jw1,
     1               nmat,fr,omega,
     1               ros,xkr,xmur,xmr,deltp,delts,qp,fq1,fq2,
     1               tau1,tau2,xmw,
     1               rho,ngnod,
     1               alfall,alfarr,alfabb,alfatt,
     1               betall,betarr,betabb,betatt,
     1               beta11l,beta11r,beta11b,beta11t,
     1               beta22l,beta22r,beta22b,beta22t,h,kdel,
     1               xsou,ysou,jsou,ksou,xnod,ynod,fsour,
     1               iter,iwsnap,xln,xmu,
     1               deltal,deltar,deltab,deltat,xld,xld1,xld2,
     1               xld3,xld4,xld5,xld6,xld7,u1,u2,u3,u4,u5,u6,u7)
1102    continue
       if(mod(ny,2).ne.0) then
       nbl=ny
       nr=ny-1
       endif
       if(mod(ny,2).eq.0) then
       nbl=ny-1
       nr=ny
       endif
c   set maximum number of  inner iterations 
c acording to the  frequency number ( less number of 
c  iterations for low frequencies)
         maxi = maxiter
         if(jw.le.jwlow)maxi = maxlow

            do  1001 iter = 1, maxi
c                     write(6,8831)iter
c                    write(10,8831)iter

8831     format(/1x,' inner iteration number ',i6)
c
c   performs one inner iteration
c
c   Fills buffer for each type of block ( 0-8)
c
c     TMP - PARALLEL CODE
c       call setbuf(nx,ny,nmax,ubln,utln,
c     1                   ubrn,utrn,
c     1                   laglbn,lagltn,lagrbn,lagrtn,
c     1                   lagbln,lagbrn,lagtln,lagtrn,sendvec,recvec,
c     1                   nsize)
c
c    save current iteration for error check

            do 1925 j=0,nx+1
            do 1925 k=0,ny+1
          u1lnp1(j,k) =  u1ln(j,k)
          u1tnp1(j,k) =  u1tn(j,k)
          u1bnp1(j,k) =  u1bn(j,k)
          u1rnp1(j,k) =  u1rn(j,k)
          u2lnp1(j,k) =  u2ln(j,k)
          u2tnp1(j,k) =  u2tn(j,k)
          u2bnp1(j,k) =  u2bn(j,k)
          u2rnp1(j,k) =  u2rn(j,k)
          lag1lnp1(j,k) = lag1ln(j,k)
          lag2lnp1(j,k) = lag2ln(j,k)
          lag1bnp1(j,k) = lag1bn(j,k)
          lag2bnp1(j,k) = lag2bn(j,k)
1925       continue
c
c Loop over black strips in the x-direction
c
          do 1041 k=1,nbl,2
       call         solv1it(k,nx,ny,jw,jw1,u1ln,u1tn,u1bn,u1rn,
     1                      lag1ln,lag1tn,lag1bn,lag1rn,
     1                      u2ln,u2tn,u2bn,u2rn,
     1                      lag2ln,lag2tn,lag2bn,lag2rn,
     1                      nmat,fr,omega,hover6,
     1                      ros,xkr,xmur,xmr,deltp,delts,qp,fq1,fq2,
     1                      tau1,tau2,xmw,
     1                      rho,ngnod,
     1                      beta11l,beta11r,beta11b,beta11t,
     1                      beta22l,beta22r,beta22b,beta22t,h,kdel,
     1                      xsou,ysou,jsou,ksou,xnod,ynod,fsour,
     1                      iter,iwsnap,deltal,deltar,deltab,deltat,
     1                      isourid,xld,xld1,xld2,xld3,xld4,xld5,
     1                      xld6,xld7,u1,u2,u3,u4,u5,u6,u7)
1041     continue
c
c updates Lagrange multipliers
c
          do 1042 k=1,nbl,2
      call       uplag(k,nx,ny,beta11l,beta11r,beta11b,beta11t,u1ln,
     1               u1tn,u1bn,u1rn,
     1               lag1ln,lag1tn,lag1bn,lag1rn,
     1               beta22l,beta22r,beta22b,beta22t,u2ln,
     1               u2tn,u2bn,u2rn,
     1               lag2ln,lag2tn,lag2bn,lag2rn,iter)
1042     continue
c   Fills buffer for each type of block ( 0-8)
c
c     TMP - PARALLEL CODE
c       call setbuf(nx,ny,nmax,ubln,utln,
c     1                   ubrn,utrn,
c     1                   laglbn,lagltn,lagrbn,lagrtn,
c     1                   lagbln,lagbrn,lagtln,lagtrn,sendvec,recvec,
c     1                   nsize)

          do 1043 k=2,nr,2
       call         solv1it(k,nx,ny,jw,jw1,u1ln,u1tn,u1bn,u1rn,
     1                      lag1ln,lag1tn,lag1bn,lag1rn,
     1                      u2ln,u2tn,u2bn,u2rn,
     1                      lag2ln,lag2tn,lag2bn,lag2rn,
     1                      nmat,fr,omega,hover6,
     1                      ros,xkr,xmur,xmr,deltp,delts,qp,fq1,fq2,
     1                      tau1,tau2,xmw,
     1                      rho,ngnod,
     1                      beta11l,beta11r,beta11b,beta11t,
     1                      beta22l,beta22r,beta22b,beta22t,h,kdel,
     1                      xsou,ysou,jsou,ksou,xnod,ynod,fsour,
     1                      iter,iwsnap,deltal,deltar,deltab,deltat,
     1                      isourid,xld,xld1,xld2,
     1               xld3,xld4,xld5,xld6,xld7,u1,u2,u3,u4,u5,u6,u7)
1043     continue
c
c updates Lagrange multipliers
c
          do 1044 k=2,nr,2
      call       uplag(k,nx,ny,beta11l,beta11r,beta11b,beta11t,u1ln,
     1               u1tn,u1bn,u1rn,
     1               lag1ln,lag1tn,lag1bn,lag1rn,
     1               beta22l,beta22r,beta22b,beta22t,u2ln,
     1               u2tn,u2bn,u2rn,
     1               lag2ln,lag2tn,lag2bn,lag2rn,iter)
1044     continue
               factor=.99d0

            do 7025 j=1,nx
            do 7025 k=1,ny
          u1ln(j,k) =(1.d0-factor)*u1lnp1(j,k)+u1ln(j,k)*factor
          u1tn(j,k) =(1.d0-factor)*u1tnp1(j,k)+u1tn(j,k)*factor
          u1bn(j,k) =(1.d0-factor)*u1bnp1(j,k)+u1bn(j,k)*factor
          u1rn(j,k) =(1.d0-factor)*u1rnp1(j,k)+u1rn(j,k)*factor
          u2ln(j,k) =(1.d0-factor)*u2lnp1(j,k)+u2ln(j,k)*factor
          u2tn(j,k) =(1.d0-factor)*u2tnp1(j,k)+u2tn(j,k)*factor
          u2bn(j,k) =(1.d0-factor)*u2bnp1(j,k)+u2bn(j,k)*factor
          u2rn(j,k) =(1.d0-factor)*u2rnp1(j,k)+u2rn(j,k)*factor

      lag1ln(j,k)=(1.d0-factor)*lag1lnp1(j,k)+lag1ln(j,k)*factor
      lag2ln(j,k)=(1.d0-factor)*lag2lnp1(j,k)+lag2ln(j,k)*factor
      lag1bn(j,k)=(1.d0-factor)*lag1bnp1(j,k)+lag1bn(j,k)*factor
      lag2bn(j,k)=(1.d0-factor)*lag2bnp1(j,k)+lag2bn(j,k)*factor
7025       continue


      if(iter.eq.1) errn=1.d0
      if(iter.gt.1)then
c
c  Checks if desired error reduction  has been  achieved
             errn = 0.d0
              den = 0.d0
             do 1011 j=1,nx
              do 1011  k=1,ny
             errn = errn + ( cdabs( u1lnp1(j,k) - u1ln(j,k) ))**2
     1                   + ( cdabs( u1tnp1(j,k) - u1tn(j,k) ))**2
     1                   + ( cdabs( u1bnp1(j,k) - u1bn(j,k) ))**2
     1                   + ( cdabs( u1rnp1(j,k) - u1rn(j,k) ))**2
     1                   + ( cdabs( u2lnp1(j,k) - u2ln(j,k) ))**2
     1                   + ( cdabs( u2tnp1(j,k) - u2tn(j,k) ))**2
     1                   + ( cdabs( u2bnp1(j,k) - u2bn(j,k) ))**2
     1                   + ( cdabs( u2rnp1(j,k) - u2rn(j,k) ))**2

             den  = den +  ( cdabs( u1lnp1(j,k) + u1ln(j,k) ))**2
     1                   + ( cdabs( u1tnp1(j,k) + u1tn(j,k) ))**2
     1                   + ( cdabs( u1bnp1(j,k) + u1bn(j,k) ))**2
     1                   + ( cdabs( u1rnp1(j,k) + u1rn(j,k) ))**2
     1                   + ( cdabs( u2lnp1(j,k) + u2ln(j,k) ))**2
     1                   + ( cdabs( u2tnp1(j,k) + u2tn(j,k) ))**2
     1                   + ( cdabs( u2bnp1(j,k) + u2bn(j,k) ))**2
     1                   + ( cdabs( u2rnp1(j,k) + u2rn(j,k) ))**2

1011       continue
c            write(6,*)' errn',errn,'den',den
            
           suml(1) = errn
           suml(2) = den
           if(den.lt.1.d-12) den = 1.d0
              errn = errn/den
              errn = 2.d0*dsqrt(errn)

c          TMP -PARALLEL CODE
c           call gdsum(suml,2,swork)
c           errn = suml(1)
c           den = suml(2)
c           errn = errn/den
c           errn = dsqrt(errn)
c           errn = 2.d0*errn
       endif

      if(blockid.eq.ncontrol.and.mod(iter,100).eq.0) then
            write(6,291)errn,iter,den
291     format(/1x,' global error = ',e20.7, ' iter. number = ',i5,
     1  ' denomin. = ',e20.7)
      endif

      if(errn.lt.reduc)then
      if(blockid.eq.ncontrol) then
           write(6,66291)jw,iter,errn
66291     format(/1x,' convergence  for freq. # ',i5,
     1               ' achieved in ',i5,' inner iterations ',/,
     1               ' relative error value = ',e20.8/)
      endif
c
c   goes to solve for next omega
c
         go to 3005
         endif
c
c    ends  iteration
c
c
c    ends  inner  iteration
c
1001        continue

      if(blockid.eq.ncontrol) then
            write(6,64291)jw,iter,errn
64291     format(/1x,' NO convergence  for freq. # ',i5,
     1               ' after  ',i5,' inner iterations ',/,
     1               ' relative error value reduction = ',e20.8/)
       endif

3005    continue

         write(14,776)jw,iter
776      format(i7,2x,i7)	
c
c       actualizes snapshots in the time domain in matrix tpic
c       for the times specified in vector tsnap(ntsnap) using the
c       solution obtained  for the current frequency
c       to compute the corresponding terms  in the discrete
c       inverse Fourier transform ( two options according
c       to the quadrature choice in  keyqua)

           jjw=jw
         if(keyqua.eq.1)then
            call finvpic1(jjw,nx,ny,u1ln,u1tn,u1bn,u1rn,
     1                    u2ln,u2tn,u2bn,u2rn,
     1                    tpic1,tpic2,ntsnap,itsnap,dt,delw)
         else
            call finvpic2(jjw,nx,ny,u1ln,u1tn,u1bn,u1rn,
     1                    u2ln,u2tn,u2bn,u2rn,
     1                    tpic1,tpic2,ntsnap,itsnap,dt,delw)
            endif

       call       savtrace(nrec,jw,iter,nx,ny,irx,iry,fu1,fu2,fdivu,
     1                     u1ln,u1bn,u1rn,u1tn,
     1                     u2ln,u2bn,u2rn,u2tn,h,jw1,jw2)



          do 44551 iw=1,nwsnap
           if(jw.eq.iwsnap(1)) then

c   writes snapshots in frequency ( solution for ONLY one specified frequency)
c   in 15 and 16  (real parts of horiz. and vertical components)
c  ( averaged sol. at center of cells)
c  also writes   slices of snapshots in frequency of u1  and u2
c   are written in 17 and 18 ( real parts)


c
             do 44281 k=1,ny
             do 44282  j=1,nx
              avsol1 =   .25* (u1ln(j,k)  +
     1                        u1tn(j,k)  +
     1                        u1bn(j,k)  +
     1                        u1rn(j,k)     )

            if(cdabs(avsol1).lt.1.e-14) avsol1 = dcmplx(0.d0,0.d0)
             write(15,1482)dreal(avsol1)
1482   format(e12.5)
c             write(22,1482)dimag(avsol1)

             avsol2 =   .25* (u2ln(j,k)  +
     1                        u2tn(j,k)  +
     1                        u2bn(j,k)  +
     1                        u2rn(j,k)     )

            if(cdabs(avsol2).lt.1.e-14) avsol2 = dcmplx(0.d0,0.d0)
              write(16,1482)dreal(avsol2)
c             write(24,1482)dimag(avsol2)
44282      continue
c             write(19+iw,6611)
c             write(24+iw,6611)
6611     format(/)

44281      continue

                 do  j=1,nx
                   k=ny/2
              avsol1 =   .25* (u1ln(j,k) +
     1                        u1tn(j,k)  +
     1                        u1bn(j,k)  +
     1                        u1rn(j,k)     )

            if(cdabs(avsol1).lt.1.e-14) avsol1 = dcmplx(0.d0,0.d0)
       write(17,4423)(j-1)*h+h/2.,dreal(avsol1)
4423   format(2e20.8)
                 enddo	    
	    
                do  k=1,ny
		
                   j=nx/2
		   
              avsol2=   .25* (u2ln(j,k)  +
     1                        u2tn(j,k)  +
     1                        u2bn(j,k)  +
     1                        u2rn(j,k)     )

            if(cdabs(avsol2).lt.1.e-14) avsol2 = dcmplx(0.d0,0.d0)

c        if(blockid.eq.nsx*(nsy-1))then

       write(18,4423)(k-1)*h+h/2.,dreal(avsol2)


               enddo


            endif
44551    continue
c
c   ends  main loop in frequency
c
3000        continue


c   writes snapshots and  space slices of snapshots in the time
c   domain . Also writes amplitude spectrum of the
c   recorded traces at the specified receiver locations and  obtains
c   their  inverse Fourier transform . Finally writes  in disk
c    the traces in the  time domain
c
      call outime(nx,ny,ntsnap,tpic1,tpic2,fu1,fu2,fdivu,uu,nt,
     1               h,dt,delf,delw,jw1,jw2,nrec,jsou,ksou,keyqua)

         write(6,2356)timer()
2356     format(/1x,'tiempo=',g20.8)

             stop
              end


***********************************************************************
c
c
      subroutine outime(nx,ny,ntsnap,tpic1,tpic2,fu1,fu2,fdivu,uu,nt,
     1               h,dt,delf,delw,jw1,jw2,nrec,jsou,ksou,keyqua)
      implicit double precision (a-h,o-z)
      
c      parameter(  mnx=300 ,   mny=300,mlsour=600,mnmat=20)
c      parameter(ntstep=50000,mnrec=150,mtsnap=10)
         include 'sizes_v16'
	 

      
      integer nx, ny, k,jsou,ksou,nrec
      complex*16 fu1(mlsour,mnrec),fu2(mlsour,mnrec),
     1           fdivu(mlsour,mnrec),x1(mlsour),x2(mlsour),xdiv(mlsour)
      dimension tpic1(mnx,mny,mtsnap),uu(ntstep),tpic2(mnx,mny,mtsnap)

           write(6,*) " enters outime"
      pi = 4.*datan(1.d0)
c
c   writes in 40+nn-s snapshots in time domain
c     and in 50+nn slices of snapshots in time domain, nn=1,ntsnap
c
      do 7743 nn=1,ntsnap
         do 7243 k=1,ny
            do 7143 j=1,nx
               write(40+nn-1,*)j,k,tpic1(j,k,nn)*delw/pi
7143        continue
c          write(40+nn,6611)
7243      continue
6611     format(/)

7743        continue

c
        do 4563 nn=1,ntsnap
c        write(50+nn, 340)((k-1)*h*dsqrt(2.0d0),
c     1                    tpic1(k,k,nn)*delw/pi,k=1,ny)

4563   continue

               if(nx.le.7.and.ny.le.7)then
	       
c           do  nn=1,1c
c	   write(19,*)
c	   write(19,*)' horizontal  comp snap number  nn= ',nn
c         do k=1,nyc
c	 write(19,4444)(tpic1(j,k,nn)*delw/pi,j=1,nx)
c	 enddo

c         enddo	 
	       endif


c
c   writes in  50+nn-1 snapshots in time domain
c     and in 55+nn slices of snapshots in time domain, nn=1,ntsnap
c
      do 7742 nn=1,ntsnap
         do 7542 k=1,ny
            do 7642 j=1,nx
               write(50+nn-1,*)j,k,tpic2(j,k,nn)*delw/pi
7642         continue
c          write(50+nn,6611)
7542        continue
7742     continue
               if(nx.le.7.and.ny.le.7)then
           do  nn=1,1
	   write(19,*)
	   write(19,*)' vertical comp snap number  nn= ',nn
c	   write(18,*)' since it is printed by col. must be equal'
c	   write(18,*)' to the printout of the horizontal comp.'
	   write(19,*)
         do k=1,ny
	 write(19,*)(k,tpic2(j,k,nn)*delw/pi,j=1,nx)
	 enddo
4444     format(7e15.5)
         enddo	 

              endif
c
c      do 4562 nn=1,ntsnap
c         write(55+nn, 340)((k-1)*h+h/2.,tpic2(jsou,k,nn)*delw/pi,k=1,ny)
c4562   continue
c
c      computes the inverse fourier transform to obtain the traces
c
c     loop over the receivers
c
 340  format(2g15.4)
9157  format(g15.4)

      do 86437 k=1,nrec

         do 67854 n=jw1,jw2
            x1(n) = fu1(n,k)
67854    continue
c
c   for standard quadrature choice sets the value of the
c   Fourier transform of the traces  at  omega= 0
c   equal to the value at omega = delw
c
           if(keyqua.eq.1)then
            x1(1)=x1(2)
              endif
c
c   Writes amplitud spectrum of  current trace for u1 before obtaining
c   its inverse Fourier transform
c
c
         if(keyqua.eq.1)then
c         write(90+k,340)((jw-1)*delf,dsqrt(dreal(fu1(jw,k))**2
c     $        +dimag(fu1(jw,k))**2),jw=jw1,jw2)
c
c  Performs the inverse Fourier Transform of the current trace
c  according to the quedrature choice.
c
            call finvu1(x1,jw2,uu,nt,dt,delw)
         endif
         if(keyqua.eq.2)then
c         write(90+k,340)((jw-1)*delf+.5d0*delf,dsqrt(dreal(fu1(jw,k))**2
c     $        +dimag(fu1(jw,k))**2),jw=jw1,jw2)

            call finvu2(x1,jw2,uu,nt,dt,delw)

         endif
c Cambio Juan 
c  Writes in 60 + k-1   traces for u1 in the time domain
c
c
c         if(k.le.10)then   
c         write(60+k-1,340)((n-1)*dt,uu(n),n=1,nt)
c	 endif
         write(98,339)(uu(n),n=1,nt)
86437     continue
339      format(g15.4)
         do 86438 k=1,nrec

         do 77854 n=jw1,jw2
            x2(n) = fu2(n,k)
77854    continue
c
c   for standard quadrature choice sets the value of the
c   Fourier transform of the traces  at  omega= 0
c   equal to the value at omega = delw
c
           if(keyqua.eq.1)then
               x2(1)=x2(2)
           endif

         if(keyqua.eq.1)then
c          write(100+k,340)((jw-1)*delf,dsqrt(dreal(fu2(jw,k))**2
c     $        +dimag(fu2(jw,k))**2),jw=jw1,jw2)
c
c  Performs the inverse Fourier Transform of the current trace
c  according to the quedrature choice.
c
            call finvu1(x2,jw2,uu,nt,dt,delw)
              endif
         if(keyqua.eq.2)then
c        write(100+k,340)((jw-1)*delf+.5d0*delf,dsqrt(dreal(fu2(jw,k))**2
c     $        +dimag(fu2(jw,k))**2),jw=jw1,jw2)

             call finvu2(x2,jw2,uu,nt,dt,delw)

         endif
c
c  Writes in 70 + k-1  traces for u2 in the time domain
c
c Cambio Juan
c         if(k.le.10)then   
c         write(70+k-1,340)((n-1)*dt,uu(n),n=1,nt)
c	 endif
        write(99,339)(uu(n),n=1,nt)
86438   continue
c         do 86439 k=1,nrec

c         do 87854 n=jw1,jw2
c         xdiv(n)=fdivu(n,k)
c87854    continue
c
c   for standard quadrature choice sets the value of the
c   Fourier transform of the traces  at  omega= 0
c   equal to the value at omega = delw
c
c           if(keyqua.eq.1)then
c            xdiv(1)=xdiv(2)
c              endif
c
c         if(keyqua.eq.1)then
c      write(200+k,340)((jw-1)*delf,dsqrt(dreal(fdivu(jw,k))**2
c     $        +dimag(fdivu(jw,k))**2),jw=jw1,jw2)
c
c  Performs the inverse Fourier Transform of the current trace
c  according to the quadrature choice.
c
c            call finvu1(xdiv,jw2,uu,nt,dt,delw)
c              endif
c         if(keyqua.eq.2)then
c       write(200+k,340)((jw-1)*delf,dsqrt(dreal(fdivu(jw,k))**2
c     $        +dimag(fdivu(jw,k))**2),jw=jw1,jw2)

c             call finvu2(xdiv,jw2,uu,nt,dt,delw)

c         endif
c
c  Writes in 80 + k  current trace for divergence of u  in the time domain
c
c
c         write(80+k,340)((n-1)*dt,uu(n),n=1,nt)
c86439 continue
           write(6,*) " leaves outime"

           return
          end

**********************************************************************
       subroutine finvpic1(jjw,nx,ny,u1ln,u1tn,u1bn,u1rn,
     1                    u2ln,u2tn,u2bn,u2rn,
     1                    tpic1,tpic2,ntsnap,itsnap,dt,delw)
c      parameter(  mnx=300 ,   mny=300,mlsour=600,mnmat=20)
c      parameter(ntstep=50000,mnrec=150,mtsnap=10)
c      parameter(mnx=201 ,mny=201,mlsour=600,mnmat=20)
c      parameter(mngx=203, mngy=203)
c      parameter(ntstep=5000,mnrec=150,mtsnap=10)
           include 'sizes_v16'
	   


      implicit double precision(a-h,o-z)
      complex*16 u1ln(0:mnx+1,0:mny+1),u1tn(0:mnx+1,0:mny+1),
     1           u1bn(0:mnx+1,0:mny+1)
      complex*16 u1rn(0:mnx+1,0:mny+1)
c
      complex*16 u2ln(0:mnx+1,0:mny+1),u2tn(0:mnx+1,0:mny+1),
     1           u2bn(0:mnx+1,0:mny+1)
      complex*16 u2rn(0:mnx+1,0:mny+1)
      dimension tpic1(mnx,mny,mtsnap),tpic2(mnx,mny,mtsnap)
      dimension itsnap(mtsnap)
      complex*16 avsol1,avsol2
c
      twopi=8.*datan(1.d0)
      pi=.5d0*twopi
      do 77 k=1,ny
         do 77 j=1,nx

              avsol1 =   .25* (u1ln(j,k)  +
     1                        u1tn(j,k)  +
     1                        u1bn(j,k)  +
     1                        u1rn(j,k)     )

       if(cdabs(avsol1).lt.1.e-14) avsol1 = dcmplx(0.d0,0.d0)

            do  77 jt = 1,ntsnap
               fjt=itsnap(jt)
               fjt = fjt - 1.d0
               fjw=jjw
               fjw = fjw -1.d0
               v = fjw * delw * fjt * dt
               tpic1(j,k,jt) = tpic1(j,k,jt) +
     $              dreal( avsol1 * dcmplx(dcos(v),dsin(v)) )
 77         continue
         do 772 k=1,ny
         do 772 j=1,nx

              avsol2 =  .25* (u2ln(j,k)  +
     1                        u2tn(j,k)  +
     1                        u2bn(j,k)  +
     1                        u2rn(j,k)     )

         if(cdabs(avsol2).lt.1.e-14) avsol2 = dcmplx(0.d0,0.d0)

            do  772 jt = 1,ntsnap
               fjt=itsnap(jt)
               fjt = fjt - 1.d0
               fjw=jjw
               fjw = fjw -1.d0
               v = fjw * delw * fjt * dt
               tpic2(j,k,jt) = tpic2(j,k,jt) +
     $              dreal( avsol2 * dcmplx(dcos(v),dsin(v)) )
772           continue

      return
      end

***********************************************************************

       subroutine finvpic2(jjw,nx,ny,u1ln,u1tn,u1bn,u1rn,
     1                    u2ln,u2tn,u2bn,u2rn,
     1                    tpic1,tpic2,ntsnap,itsnap,dt,delw)
c      parameter(  mnx=300 ,   mny=300,mlsour=600,mnmat=20)
c      parameter(ntstep=50000,mnrec=150,mtsnap=10)

        include 'sizes_v16'
	

      implicit double precision(a-h,o-z)
      complex*16 u1ln(0:mnx+1,0:mny+1),u1tn(0:mnx+1,0:mny+1),
     1           u1bn(0:mnx+1,0:mny+1)
      complex*16 u1rn(0:mnx+1,0:mny+1)
c
      complex*16 u2ln(0:mnx+1,0:mny+1),u2tn(0:mnx+1,0:mny+1),
     1           u2bn(0:mnx+1,0:mny+1)
      complex*16 u2rn(0:mnx+1,0:mny+1)
      dimension tpic1(mnx,mny,mtsnap),tpic2(mnx,mny,mtsnap)
      dimension itsnap(mtsnap)
      complex*16 avsol1,avsol2
c
      twopi=8.*datan(1.d0)
      pi=.5d0*twopi
      do 77 k=1,ny
         do 77 j=1,nx

             avsol1 =  .25* (u1ln(j,k)  +
     1                        u1tn(j,k)  +
     1                        u1bn(j,k)  +
     1                        u1rn(j,k)     )

       if(cdabs(avsol1).lt.1.e-14) avsol1 = dcmplx(0.d0,0.d0)

            do  77  jt = 1,ntsnap
               fjt=itsnap(jt)
               fjt = fjt - 1.d0
               fjw=jjw
               fjw = fjw -1.d0
               fjw = fjw + .5d0
               v = fjw * delw * fjt * dt
               tpic1(j,k,jt) = tpic1(j,k,jt) +
     $              dreal( avsol1 * dcmplx(dcos(v),dsin(v)) )
 77         continue
           do 772 k=1,ny
           do 772 j=1,nx

             avsol2 =  .25* (u2ln(j,k)  +
     1                        u2tn(j,k)  +
     1                        u2bn(j,k)  +
     1                        u2rn(j,k)     )

        if(cdabs(avsol2).lt.1.e-14) avsol2 = dcmplx(0.d0,0.d0)

            do  772  jt = 1,ntsnap
               fjt=itsnap(jt)
               fjt = fjt - 1.d0
               fjw=jjw
               fjw = fjw -1.d0
               fjw = fjw + .5d0
               v = fjw * delw * fjt * dt
               tpic2(j,k,jt) = tpic2(j,k,jt) +
     $              dreal( avsol2 * dcmplx(dcos(v),dsin(v)) )
 772         continue

      return
      end
c*********************************************************************
       subroutine savtrace(nrec,jw,iter,nx,ny,irx,iry,fu1,fu2,fdivu,
     1                     u1ln,u1bn,u1rn,u1tn,
     1                     u2ln,u2bn,u2rn,u2tn,h,jw1,jw2)
     
c      parameter(  mnx=300 ,   mny=300,mlsour=600,mnmat=20)
c      parameter(ntstep=50000,mnrec=150,mtsnap=10)
      include 'sizes_v16'
      implicit double precision (a-h,o-z)
      complex*16 fu1(mlsour,mnrec),fu2(mlsour,mnrec),
     1           fdivu(mlsour,mnrec)

        complex*16 avdivu,avsol1,avsol2
        dimension  irx(mnrec),iry(mnrec)
c
      complex*16 u1ln(0:mnx+1,0:mny+1),u1tn(0:mnx+1,0:mny+1),
     1           u1bn(0:mnx+1,0:mny+1)
      complex*16 u1rn(0:mnx+1,0:mny+1)
c
      complex*16 u2ln(0:mnx+1,0:mny+1),u2tn(0:mnx+1,0:mny+1),
     1           u2bn(0:mnx+1,0:mny+1)
      complex*16 u2rn(0:mnx+1,0:mny+1)

c
c saves Fourier transform of traces at the specified receiver locations
c
         do 7436 i = 1, nrec
           j=irx(i)
           k=iry(i)
             avsol1 =   .25* (u1ln(j,k)  +
     1                        u1tn(j,k)  +
     1                        u1bn(j,k)  +
     1                        u1rn(j,k)     )
         if(cdabs(avsol1).lt.1.e-14) avsol1 = dcmplx(0.d0,0.d0)

         fu1(jw,i) = avsol1
              avsol2=   .25* (u2ln(j,k)  +
     1                        u2tn(j,k)  +
     1                        u2bn(j,k)  +
     1                        u2rn(j,k)     )

         if(cdabs(avsol2).lt.1.e-14) avsol2 = dcmplx(0.d0,0.d0)

         fu2(jw,i) = avsol2
          avdivu=             (.5/h)* ( -u1ln(j,k)  -
     1                                   u1tn(j,k)  +
     1                                   u1bn(j,k)  +
     1                                   u1rn(j,k)  -
     1                                   u2ln(j,k)  +
     1                                   u2tn(j,k)  -
     1                                   u2bn(j,k)  +
     1                                   u2rn(j,k)    )


         fdivu(jw,i) = avdivu
 7436    continue


         if(jw.eq.-1)then

           write(6,6622)
6622       format(/1x,' matriz fu1  en  savtrace '/)
            do 77 n=1,nrec
            write(6,55)n,jw
55      format(/1x,' fourier transf. de receptor u1- jw = ',2i5,/)
            write(6,9157)dreal(fu1(jw,n))
77            continue
                  endif
9157  format(g15.4)
            return
               end
*****************************************************************************
      subroutine inbeta(nx,ny,h,omega,rho,beta11l,beta11r,beta11t,
     1                 beta11b,beta22l,beta22r,beta22t,beta22b,
     1                 xln,xmu,jw)
c c     parameter(  mnx=300 ,   mny=300)
       include 'sizes_v16'
       
      implicit double precision (a-h,o-z)
c
c    sets  iteration parameters  betal ,betar,betat,betab ( = .57/h)
c
c
c  Iteration  matrix coefficients  beta
c
      complex*16 beta11l(0:mnx+1,0:mny+1),beta11r(0:mnx+1,0:mny+1),
     1           beta11b(0:mnx+1,0:mny+1)
      complex*16 beta11t(0:mnx+1,0:mny+1)
      complex*16 beta22l(0:mnx+1,0:mny+1),beta22r(0:mnx+1,0:mny+1),
     1           beta22b(0:mnx+1,0:mny+1)
      complex*16 beta22t(0:mnx+1,0:mny+1)
      dimension rho(0:mnx+1,0:mny+1)
      complex*16 xln(0:mnx+1,0:mny+1),xmu(0:mnx+1,0:mny+1)
      complex*16  avalfa,avbeta,aim
c Cambio Juan
      complex*16 xmw_jk,xmw_j1k,vp_c_jk,vp_c_j1k,vs_c_jk,vs_c_j1k

*  end dimension stetements
      
           if(jw.le.5)then
	   
*  facbeta = 10  reduce muchisimo el nro de iter. las  5 mas  baja frec.	   
           facbeta = 10.
	   else
*  facbeta = 10  reduce muchisimo el nro de iter. en bajas frec.
	   
	   facbeta=1.d0
	   endif
	   
	   
            aim = dcmplx(0.d0,1.d0)

      do 1000 j=1,nx
      do 1000 k=1,ny


	   
       xmw_jk = xln(j,k)+2.d0*xmu(j,k)
       xmw_j1k = xln(j-1,k)+2.d0*xmu(j-1,k)
       
         vp_c_jk=cdsqrt(xmw_jk/rho(j,k))
         vp_c_j1k=cdsqrt(xmw_j1k/rho(j-1,k))	 
	 
         vp_jk=1.d0/(dreal(1.d0/vp_c_jk))
         vp_j1k=1.d0/(dreal(1.d0/vp_c_j1k))	 
	 
	 
	 vs_c_jk=cdsqrt(xmu(j,k)/rho(j,k))
	 vs_c_j1k=cdsqrt(xmu(j-1,k)/rho(j-1,k))
	 	 
         vs_jk=1.d0/(dreal(1.d0/vs_c_jk)) 
         vs_j1k=1.d0/(dreal(1.d0/vs_c_j1k)) 



        avalfa = 0.5d0*(vp_jk + vp_j1k)

        avbeta = 0.5d0*(vs_jk + vs_j1k)	   	   

           aver  = .5d0*(rho(j,k)+rho(j-1,k))

           beta11l(j,k) = aim *aver*avalfa*facbeta*omega

           beta22l(j,k) = aim *aver*avbeta*facbeta*omega


1000       continue

           do 1001 j=1,nx
           do 1001 k=1,ny


         xmw_jk = xln(j,k)+2.d0*xmu(j,k)
         xmw_j1k = xln(j+1,k)+2.d0*xmu(j+1,k)
       
         vp_c_jk=cdsqrt(xmw_jk/rho(j,k))
         vp_c_j1k=cdsqrt(xmw_j1k/rho(j+1,k))	 
	 
         vp_jk=1.d0/(dreal(1.d0/vp_c_jk))
         vp_j1k=1.d0/(dreal(1.d0/vp_c_j1k))	 
	 
	 
	 vs_c_jk=cdsqrt(xmu(j,k)/rho(j,k))
	 vs_c_j1k=cdsqrt(xmu(j-1,k)/rho(j+1,k))
	 	 
         vs_jk=1.d0/(dreal(1.d0/vs_c_jk)) 
         vs_j1k=1.d0/(dreal(1.d0/vs_c_j1k)) 
	   
          avalfa = 0.5d0*(vp_jk + vp_j1k)

          avbeta = 0.5d0*(vs_jk + vs_j1k)	

           aver  = .5d0*(rho(j,k)+rho(j+1,k))

           beta11r(j,k) = aim *aver*avalfa*facbeta*omega

           beta22r(j,k) = aim *aver*avbeta*facbeta*omega


1001       continue

           do 1002 j=1,nx
           do 1002 k=1,ny
	  	   	   
         xmw_jk = xln(j,k)+2.d0*xmu(j,k)
         xmw_j1k = xln(j,k-1)+2.d0*xmu(j,k-1)
       
         vp_c_jk=cdsqrt(xmw_jk/rho(j,k))
         vp_c_j1k=cdsqrt(xmw_j1k/rho(j,k-1))	 
	 
         vp_jk=1.d0/(dreal(1.d0/vp_c_jk))
         vp_j1k=1.d0/(dreal(1.d0/vp_c_j1k))	 
	 
	 
	 vs_c_jk=cdsqrt(xmu(j,k)/rho(j,k))
	 vs_c_j1k=cdsqrt(xmu(j,k-1)/rho(j,k-1))

         vs_jk=1.d0/(dreal(1.d0/vs_c_jk)) 
         vs_j1k=1.d0/(dreal(1.d0/vs_c_j1k))
	 	   
          avalfa = 0.5d0*(vp_jk + vp_j1k)

          avbeta = 0.5d0*(vs_jk + vs_j1k)

           aver  = .5d0*(rho(j,k)+rho(j,k-1))

           beta11b(j,k) = aim *aver*avalfa*facbeta*omega

           beta22b(j,k) = aim *aver*avbeta*facbeta*omega


1002       continue

           do 1003 j=1,nx
           do 1003 k=1,ny

	   
         xmw_jk = xln(j,k)+2.d0*xmu(j,k)
         xmw_j1k = xln(j,k+1)+2.d0*xmu(j,k+1)
       
         vp_c_jk=cdsqrt(xmw_jk/rho(j,k))
         vp_c_j1k=cdsqrt(xmw_j1k/rho(j,k+1))	 
	 
         vp_jk=1.d0/(dreal(1.d0/vp_c_jk))
         vp_j1k=1.d0/(dreal(1.d0/vp_c_j1k))	 
	 
	 
	 vs_c_jk=cdsqrt(xmu(j,k)/rho(j,k))
	 vs_c_j1k=cdsqrt(xmu(j,k+1)/rho(j,k+1))
	 	 
         vs_jk=1.d0/(dreal(1.d0/vs_c_jk)) 
         vs_j1k=1.d0/(dreal(1.d0/vs_c_j1k)) 
	   
          avalfa = 0.5d0*(vp_jk + vp_j1k)

          avbeta = 0.5d0*(vs_jk + vs_j1k)	   
	   
	   

           aver  = .5d0*(rho(j,k)+rho(j,k+1))

           beta11t(j,k) = aim *aver*avalfa*facbeta*omega

           beta22t(j,k) = aim *aver*avbeta*facbeta*omega

1003       continue

             return
               end
******************************************************************************************
      subroutine readata(keyqua,npf,key,nmat,xsize,ysize,
     1                   ve,constp,consts,tau1,tau2,
     1                   freq,w0,alfa,stime,xnod,ynod,nx,ny,h,dt,nt,
     1                   ntsnap,itsnap,hover6,
     1                   f1,f2,f3,f4,psi,width,ts,totpul,lpulse,
     1                   source,fny,delf,delw,if1,if2,if3,if4,jw1,jw2,
     1                   matnum,xsou,ysou,jsou,ksou,
     1                   kdel,tmute,ntmute,tsnap,nrec,
     1                   nwsnap,wsnap,iwsnap,maxiter,reduc,x,fsour,
     1                   ros,xkr,xmur,xmr,deltp,delts,qp,fq1,fq2,rho,
     1                   rx,ry,irx,iry,nsize,isourid,hpx,hpy,ngx,ngy,
     1                   maxlow,jwlow,irecid,
     1                   fi,rof,qs,qpg,xkf,constg,xksc,numatdry)

      implicit double precision (a-h,o-z)

c      parameter(  mnx=300,   mny=300,mlsour=600,mnmat=20)
c      parameter(mngx=302, mngy=302)
c      parameter(ntstep=50000,mnrec=150,mtsnap=10)
       include 'sizes_v16'
       

      dimension  ros(mnmat),xkr(mnmat),xmur(mnmat),deltp(mnmat)
      real*8 xksc(mnmat)
      dimension  delts(mnmat),fq1(mnmat),fq2(mnmat),ve(mnmat)
      dimension  qp(mnmat),xmr(mnmat),constp(mnmat),consts(mnmat)
      dimension  tau1(mnmat),tau2(mnmat),irecid(mnrec)
      dimension  source(ntstep),xnod(mnx+1),ynod(mny+1)
      dimension  rho(0:mnx+1,0:mny+1)
      dimension rx(mnrec), ry(mnrec),irx(mnrec), iry(mnrec)
      dimension  wsnap(10),iwsnap(10)
      complex*16 x(mlsour),fsour(mlsour)
      dimension  itsnap(10),tsnap(10)
      integer blockid,vblockid,blockty
      common/a1/ncontrol,blockid,vblockid(2),blockty,nsx,nsy
      dimension fi(mnmat),rof(mnmat),xkf(mnmat),qs(mnmat)
c
c  Global matrix matnum 
c 
c  matnum : integer matrix containing  the material type number at
c            each grid block in the global mesh
c
      dimension matnum(0:mngx+1,0:mngy+1)
      real*8 xinic,xfin,yinic,ifin,deltarecx,deltarecy
c
c   end  dimension statements
c
      epsilo = 1.d-10
      twopi = 6.28318530717958d0
      pi = twopi*.5d0
c
c  Reads   nsx = number of processors ( blocks) in the x-direccion
c
c
c  Reads   nsy = number of processors ( blocks) in the y-direccion
c
c  ncontrol = processor number where output is being written
c
c
c  Reads   ngx = global grid size in the  x-direccion
c
c
c  Reads   ngy = global grid size in the  y-direccion
c

       read(5,170)maxlow
       read(5,150)perclow
       read(5,170)nsx
       read(5,170)nsy
       read(5,170)ncontrol
       read(5,170)ngx
       read(5,170)ngy

c     compute local grid sizes_v16
      nx = ngx/nsx
      ny = ngy/nsy

      if(blockid.eq.ncontrol) then
      write(6,1831) nsx,nsy
1831  format(/1x,'# subdomains  in x-direction nsx = ',i5,/,
     $       1x,'# subdomains  in y-direction nsy = ',i5)
      write(6,2831) ncontrol
2831  format(/1x,'# control subdomain ncontrol = ',i5)

      write(6,3831) ngx,ngy
3831  format(/1x,'Global # elements  in x-direction ngx = ',i5,/,
     $       1x, 'Global # elements  in y-direction ngy = ',i5)

      write(6,8831) nx,ny
 8831 format(/1x,'Local # elements  in x-direction nx = ',i5,/,
     $       1x, 'Local # elements  in y-direction ny = ',i5)
      endif

c     compute size of buffer for message passing
      nmax = nx
      if( nmax.lt.ny) nmax = ny
      nsize = 16*(nmax+2)*8

      if(nx.gt.mnx ) stop 77
      if(ny.gt.mny) stop 77
      read(5,150)xsize
      read(5,150) ysize
c  computes  processor grid sizes_v16  hpx, hpy
c

           hpx = xsize/nsx
           hpy = ysize/nsy


      if(blockid.eq.ncontrol) then
 150  format(e20.8)
      write(6,8382) hpx,hpy
 8382 format(/1x,' processor grid size in the x-dir  hpx = ',g20.8,/,
     $       1x, ' processor grid size in the y-dir  hpy  = ',g20.8)

      write(6,1)xsize
 1    format(/1x,' domain size xsize = ',e20.8,' m')
      write(6,2) ysize
 2    format(/1x,' domain size ysize = ',e20.8,' m')
      endif
      if(blockid.eq.ncontrol) then
        write(6,1730)maxlow,perclow
        
1730   format(/1x,'  maxlow (max.iter. in low freq range ) = ',
     1 i6,' perclow ( perc. of(low) freq. solved with maxlow = ', 
     1 e20.8)
          endif 
c
c   chooses minimum h between hx and hy
c
         hx=xsize/ngx
         hy=ysize/ngy
         h = hx
           if(h.gt.hy)h=hy
c
c      rounds xsize , ysize
c
         hover6=h/6.d0

         xsize=ngx*h
         ysize=ngy*h
      if(blockid.eq.ncontrol) then
         write(6,66291)xsize,ysize
66291    format(/1x,' rounded xsize = ',e20.8,' m ; ',/,
     $        ' rounded ysize = ',e20.8,' m '/)
      endif
c
c
c  Now when reading domain description we may have problems
c  since xsize and ysize may be smaller.
c   We may have to run twice the code  for this reason.
c The first pass just to know the rounded -to - h  sizes_v16.
c
c
      read(5,170)nwsnap
      read(5,150)(wsnap(i),i=1,nwsnap)
      read(5,170) ntsnap
      do i=1,ntsnap
      read(5,*) tsnap(i)
      enddo
      read(5,170)keyqua
      read(5,170)npf
      read(5,170)key
      read(5,150)freq
      read(5,150)stime
      
      read(5,150)f1
      read(5,150)f2
      read(5,150)f3
      read(5,150)f4
      read(5,170)maxiter
      read(5,150)reduc
      w0 = twopi*freq
      alfa= .79d0 * w0/pi
      if(nwsnap.gt.10) stop 5183
      if(ntsnap.gt.mtsnap) stop 6183
      if(ntsnap.gt.10) stop 6184      

      if(blockid.eq.ncontrol) then
      write(6,8833) h
 8833 format(/1x,' mesh size h= ',e20.8,' m')
      write(6,76234)nwsnap
76234 format(/1x,' number of snapshots in freq. domain= ',i5)
      write(6,7746)(i,wsnap(i),i=1,nwsnap)
 7746 format(/1x,' freq. to compute  snapshots in freq.domain',/,
     $     i5,3x,e20.8,' kHz')
      write(6,76232)ntsnap
76232 format(/1x,' number of snapshots in time domain= ',i5)
      write(6,7741) (i,tsnap(i),i=1,ntsnap)
 7741 format(/1x,' times to compute  snapshots in time domain',/,
     $     i5,3x,e20.8,' msec')


       write(6,87365)keyqua
87365  format(/1x,' quadrature choice=1,standard,=2,mid point',/,
     1           '  keyqua = ',i5)
      write(6,16234)npf
16234 format(/1x,' number of points to compute solution= ',/,
     1           ' in the frequency domain    npf  = ',i5)

      write(6,100)key
100   format(/1x,'  key==1 for type 1 source (tsang&rader paper) ;',
     $   /1x,'      key==2 for type 2 source(gaussian derivative)
     $      ;',i5,//)


      write(6,1305)freq
1305  format(/1x,'  frequency  freq= ',e20.8,' khz'//)
      write(6,1405)w0,alfa
1405   format(/1x,' w0 = ',e20.8,'  alfa = ',e20.8,//)
      write(6,160)stime
160   format(/1x,' total simulation time  stime =  ',e20.8,' msec'/)

         write(6,7752)f1,f2,f3,f4
 7752   format(/1x,'  parameters of  source band-pass filter',//,
     1         ' set equal to 0. if not filter is desired'//,
     1         ' f1  = ',e20.8,'   khz ',//,
     1         ' f2  = ',e20.8,'   khz ',//,
     1         ' f3  = ',e20.8,'   khz ',//,
     1         ' f4  = ',e20.8,'   khz ',//)

           write(6,2190)maxiter
2190     format(/1x,'  maxiter =  max. # inner iterations ',i5)
           write(6,2590)reduc
2590     format(/1x,'  reduc =  relative error required  ',e20.8)

       endif

c
c    Computes nodal values  in xnod for the true interface
c   configuration
c
         do 55282 j=1,nx+1
         xnod(j) = (j-1)*h
55282    continue
         do 15282 k=1,ny+1
          ynod(k) = (k-1)*h
15282    continue

      read(5,170)nmat
      if(nmat.gt.mnmat) stop 222
      do i=1,nmat
      read(5,*)ros(i)
      enddo
      read(5,150)(xkr(i),i=1,nmat)
      read(5,150)(xmur(i),i=1,nmat)
      read(5,150)(deltp(i),i=1,nmat)
      read(5,150)(delts(i),i=1,nmat)
      read(5,150)(fi(i),i=1,nmat)
      read(5,150)(rof(i),i=1,nmat)
      read(5,150)(xkf(i),i=1,nmat)
      read(5,150)(xksc(i),i=1,nmat)
      read(5,170)numatdry
c
c    changes to units of msec, meters and gr
c
      do 174 i=1,nmat
      ros(i) = ros(i) * 1.d+6
c      ros(i) = (1.d0-fi(i))*ros(i)
      xkr(i)=xkr(i)*1.0d-4
      xmur(i)=xmur(i)*1.0d-4
      rof(i) = rof(i) * 1.d+6
      xkf(i) = xkf(i) * 1.0d-4
      xksc(i) = xksc(i) * 1.0d-4      
174   continue


      if(blockid.eq.ncontrol) then
c               write(6,7923)
c7923   format(/1x,' vector xnod  in readata '//)
c             write(6,34921)(xnod(j),j=1,nx+1)
c34921  format(/1x,5e15.5)
c               write(6,1923)
c1923   format(/1x,' vector ynod  in readata '//)
c             write(6,34921)(ynod(j),j=1,ny+1)

      write(6,2346)nmat
2346   format(/1x,' number of materials (nmat) = ',i5)

      write(6,172)
172   format(/1x,' mat. number   density (ros)    bulk modulus (xkr)',
     1      '   Shear modulus (xmur)'//)
      write(6,173)(i,ros(i),xkr(i),xmur(i),i=1,nmat)
173   format(1x,i5,7x,e15.6,2x,e15.6,7x,e15.6/)
      write(6,572)
572   format(/1x,' mat. number  deltp (p-log.decr.)    ',
     1        ' delts (s-log.decr.)   '//)
      write(6,473)(i, deltp(i),delts(i),i=1,nmat)
473   format(1x,i5,7x,e15.6,7x,e15.6/)

      write(6,172)
      write(6,173)(i,ros(i),xkr(i),xmur(i),i=1,nmat)
      endif
        
      bulmin=xkr(1)
      umin=xmur(1)
      bulmax=xkr(1)
      umax=xmur(1)
       den =  xkr(1) + 4.d0*xmur(1)/3.d0
       vmin= dsqrt(den/ros(1))
       vmax= dsqrt(den/ros(1))
       vssmin=dsqrt(umin/ros(1))
       vssmax=dsqrt(umax/ros(1)) 
      if(nmat.gt.1) then
      do 176 i=2,nmat
      if(xkr(i).gt.bulmax)bulmax=xkr(i)
      if(xkr(i).lt.bulmin)bulmin=xkr(i)
      if(xmur(i).gt.umax  ) umax =xmur(i)
      if(xmur(i).lt. umin ) umin =xmur(i)
       denaux =  xkr(i) + 4.d0*xmur(i)/3.d0
       vaux = dsqrt(denaux/ros(i))
        if(vaux.gt.vmax)vmax=vaux
        if(vaux.lt.vmin)vmin=vaux
       vssaux = dsqrt(xmur(i)/ros(i))
        if(vssaux.gt.vssmax)vssmax=vssaux
        if(vssaux.lt.vssmin)vssmin=vssaux

        pp1=dsqrt((xkr(1) + 4.d0*xmur(1)/3.d0)/ros(1))
        pp2=dsqrt((xkr(2) + 4.d0*xmur(2)/3.d0)/ros(2))
        ss1=dsqrt(xmur(1)/ros(1))
        ss2=dsqrt(xmur(2)/ros(2))

 176   continue
       endif
      if(blockid.eq.ncontrol) then
       write(6,8732)bulmin,umin,bulmax,umax
8732   format(/1x,' bulmin-umin-bulmax-umax   ',//,1x,4e15.5/)
      write(6,110)vmin,vmax
110   format(/1x,'minimum  phase pp velocity   = ',e12.5,' m/msec',//
     $          ' maximum  phase pp velocity  = ',e12.5,' m/msec'//)
       write(6,9110)vssmin,vssmax
9110   format(/1x,'minimum  phase ss velocity   = ',e12.5,' m/msec',//
     $          ' maximum  phase ss velocity  = ',e12.5,' m/msec'//)

       write(6,9111) pp1,pp2,ss1,ss2
9111   format(/1x,'phase  velocity  pp1 = ',e12.5,' m/msec',//
     $          ' phase velocity pp2 = ',e12.5,' m/msec',//
     $          ' phase velocity ss1 = ',e12.5,' m/msec',//
     $          ' phase velocity ss2 = ',e12.5,' m/msec'//)


        endif
       
         do 8585 i=1,nmat
      read(5,150)fq1(i),fq2(i)

      xmr(i)=xkr(i)+4.d0*xmur(i)/3.d0
      ve(i)=dsqrt(xmr(i)/ros(i))
c
c     computes tau1(i) and tau2(i)  in msec and constant c
c     in formula (37) of liu paper (given the required qp,
c     we compute c in const(i) from (37) )
c
         if(deltp(i).lt.1.d-10)then
          constp(i)=0.d0
          consts(i)=0.d0
          constg=0.d0

               else
       qp(i)=pi/deltp(i)
       qs(i)=pi/delts(i)
       qpg=pi/deltg
       constp(i)=2.d0/(qp(i)*pi)
       consts(i)=2.d0/(qs(i)*pi)
       constg=2.d0/(qpg*pi)

          endif

      tau1(i)=1.d0/(twopi*fq1(i))
      tau2(i)=1.d0/(twopi*fq2(i))
8585   continue

      if(blockid.eq.ncontrol) then
      write(6,87223)
87223 format(/1x,'  mat. number      fq1                     fq2',
     1          '    (Liu model)  ',/)
      write(6,87524)(i,fq1(i),fq2(i),i=1,nmat)

87524 format(/1x,i5,2x,e20.8,' kHz ',e20.8,' kHz')
      write(6,7894)
7894  format(/1x,' material number     qp(i)  (Liu model)',/)
      write(6,7395)(i,qp(i),i=1,nmat)
7395  format(/1x,i5,8x,e20.8)
      write(6,76348)
76348 format(/1x,' material number     const(i)       tau1(i)(msec)  ',
     1           '        tau2 (i)(msec) '/)

      write(6,76111)(i,constp(i),tau1(i),tau2(i),i=1,nmat)
76111 format(/1x,i5,10x,e15.6,3x,e15.6,8x,e15.6)

	write(6,9235)
9235	format(/1x, 'Material  Number               Ref. Speed ve   ',
     1           ' relaxed  plane wave modulus xmr'/)
        do 66335 i=1,nmat
         write(6,66336)i,ve(i),xmr(i)
66336    format(/8x,i5,15x,e15.5,5x,e15.5)
66335     continue
           endif
c
c     computes dt using  cfl stability
c
      secfac = 0.1d0
       dt = ( h/vmax) * secfac
       
c
c     computes number of time steps in n
c
      nt = stime/dt
     
c
c
c
      if(nt.gt.ntstep)stop 999

       read(5,170)kdel

                read(5,150)tmute

      if(blockid.eq.ncontrol) then
      write(6,210)dt
210   format(/1x,' time step  dt = ',e20.8,' msec'//)
      write(6,200)nt
200   format(/1x,' number of time steps  nt = ',i6//)
       write(6,9473)kdel
9473   format(/1x,' kdel=0 : delta, kdel = 1:  d/dx(delta). kdel = ',i6)
      endif

c
c  If source is derivative of delta, checks that the source position
c  xsou  does no coincide with a nodal  point  xnod(k)
c

       if(tmute.gt.0.d0)then
       ntmute = tmute/dt
       else
       ntmute=0
       endif

       if(blockid.eq.ncontrol) then
               write(6,5273)tmute,ntmute
5273             format(/1x,'  mute in msec  tmute = ',e20.8,/,
     1         ' mute in samples   ntmute = ',i5/)
       endif

c
c  Reads  global physical position of  point source
c

      read(5,150)xsou,ysou
      if(xsou.lt.h) xsou=h
      if(xsou.gt.(xsize-h)) xsou=xsize-h
      if(ysou.lt.h) ysou=h
      if(ysou.gt.(ysize-h)) ysou=ysize-h 
 
      read(5,170)nrec
      if(nrec .gt. mnrec) stop 9920
c
c  gets  local grid corrdinates ( jsou,ksou) for the source
c  and sourceid  with the blockid number where the source
c  is located.
        js = xsou/hpx
         ks = ysou/hpy
          ks = (nsy-1)-ks

c gets blockid where the source is located
c
        isourid = ks*nsx + js
         souvid1 = mod(isourid,nsx)
          souvid2 = isourid/nsx

c       souvid1 *hpx = x-coordinate of the block isourid where
c                       the source is located

           xsourbl= souvid1*hpx

c        ((nsy-1)-souvid2)*hpy = y-coordinate of the  block where
c                                the source is located

              ysourbl = ((nsy-1)-souvid2)*hpy
           xsloc = xsou-xsourbl
           ysloc = ysou-ysourbl

      jsou=xsloc/h + 1.0d0
      ksou = ysloc/h + 1.0d0

      if(jsou.gt.nx.or.jsou.lt.1) then
      if (blockid.eq.ncontrol)then
       write(6,5693)jsou
5693   format(/1x,' wrong jsou = ',i5)
       endif 
       stop 666
        endif

      if(ksou.gt.ny.or.ksou.lt.1) then
      if (blockid.eq.ncontrol)then
       write(6,5697)ksou
5697   format(/1x,' wrong ksou = ',i5)
       endif 
       stop 666
        endif

      if(blockid.eq.ncontrol) then
      write(6,7725)jsou,ksou
 7725 format(/1x,' jsou = ',i5,'  ksou = ',i5)
       write(6,7722)xsou,ysou
 7722 format(/1x,' xsou = ',e20.8,' m ysou = ',e20.8,' m')

      write(6,7624) nrec
 7624 format(/1x,' number of receivers, nrec = ',i5)
       endif
c
c  Reads  global physical position of receivers
c
c Cambio Juan,  Seismic Unix aca

c  reads  global physical position of receivers
c
c      do 7723 i = 1, nrec
c         read(5,150) rx(i)
c         read(5,150) ry(i)
c       if(rx(i).lt.h) rx(i)=h
c       if(rx(i).gt.(xsize-h)) rx(i)=xsize-h
c       if(ry(i).lt.h) ry(i)=h
c       if(ry(i).gt.(ysize-h)) ry(i)=ysize-h 
       
              
       read(5,*)xinic
       read(5,*)yinic
       read(5,*)xfin
       read(5,*)yfin
       
       write(6,*)' xinic ',xinic
       write(6,*)
       write(6,*)' yinic ',yinic
       write(6,*)       
       write(6,*)' xfin ',xfin
       write(6,*)
       write(6,*)' yfin ',yfin
       write(6,*)         
       
       
       if(nrec.lt.2) stop
       deltarecx=(xfin-xinic)/(nrec-1.d0)
       deltarecy=(yfin-yinic)/(nrec-1.d0)
       
        write(6,*)' deltarecx ',deltarecx
       write(6,*)      
        write(6,*)' deltarecy ',deltarecy
       write(6,*)        
       
       
      do 7723 i = 1, nrec
       rx(i)=xinic+(i-1)*deltarecx
       ry(i)=yinic+(i-1)*deltarecy
     
c    
c  gets  local grid corrdinates ( jsou,ksou) for the source
c  and sourceid  with the blockid number where the source
c  is located.
        jr = rx(i)/hpx
         kr = ry(i)/hpy
          kr = (nsy-1)-kr

c gets blockid where the receiver is located
c
        irecid(i) = kr*nsx + jr
         recid1 = mod(irecid(i),nsx)
          recid2 = irecid(i)/nsx

c       recid1 *hpx = x-coordinate of the block irecid(i) where
c                       the actual receiver is located

           xrecbl= recid1*hpx

c        ((nsy-1)-recid2)*hpy = y-coordinate of the  block irecid(i) where
c                                the actual receiver is located

              yrecbl = ((nsy-1)-recid2)*hpy
           xrloc = rx(i)-xrecbl
           yrloc = ry(i)-yrecbl

      irx(i)=xrloc/h + 1.0d0
      iry(i) = yrloc/h + 1.0d0

      if(blockid.eq.ncontrol) then
         write(6,7727) i, irx(i), iry(i), rx(i), ry(i)
 7727 format(/1x,'receiver i =',i5,3x,'irx & iry = ',2i5,/,15x,
     $     'rx(i) & ry(i) = ', 2g15.8, '  m')
      endif

      if(irx(i).lt.1.or.irx(i).gt.nx+1)then
      if(blockid.eq.ncontrol) then
         write(6,7729) i, irx(i),nx+1
      endif
      stop  88888
      endif

 7729 format(/1x,'receiver i =',i5,3x,'irx(i)  = ',i5,
     $     'nx+1  = ',i5)

             if(iry(i).lt.1.or.iry(i).gt.ny+1)then

      if(blockid.eq.ncontrol) then
         write(6,7750) i, iry(i),ny+1
      endif

 7750 format(/1x,'receiver i =',i5,3x,' iry(i)  = ',i5,
     $     'ny+1  = ',i5)
                stop  88888

                   endif

 7723    continue
c  For kdel = 2  sets 1st and 2nd receivers at the 
c  corners 
c         if(kdel.eq.2)then

c           irx(1)=1
c            iry(1)=ny

c           irx(2)=nx
c            iry(2)=ny

c           irx(3)=nx
c            iry(3)=1
c      if(blockid.eq.ncontrol) then

c      do 7743 i = 1, 3

c         write(6,7836) kdel, i, irx(i)
c7836      format(/1x,' kdel -  i - irx(i) (receivers) ',3i5)
c7743    continue
c        endif
c               endif

c
       fny =  1./(2.*dt)
c
c       if(f4.gt.fny) f4=fny
c
       fnpf=npf
       delf=f4/fnpf
       delw = twopi*delf

      if(blockid.eq.ncontrol) then
       write(6,1000)fny
1000   format(/1x,' nyquist frequency = ',e20.8,' khz')
c
c   be careful , delete later
c
c       if(f4.gt.fny)f4=fny
c
c     computes delf in khz using npf and the cut frequency f4
c
      write(6,1010)dt,delf,delw
1010   format(/1x,' dt  = ',e20.8,'  msec',//
     $           ' delf = ',e20.8,'  khz'//,
     $           ' delw = ',e20.8,'  2 pi*khz',//)
c
c       computes indices related to band-pass filters
c
         write(6,7752)f1,f2,f3,f4
       endif

       if1= f1/delf+1
       if2= f2/delf+1
       if3= f3/delf+1
       if4= f4/delf+1
       if(if4.eq.1)then
       f4=fny
       f3=.9d0*fny
       if3=f3/delf+1
       if4=f4/delf+1
       endif
       if(if3.eq.if4)if3=if4-1

c
c   computes indices iwsnap() related to snapshots in
c   the space- frequency domain
c
      do 4488 i=1,nwsnap
         iwsnap(i)= wsnap(i)/delf + 1.
 4488 continue
c
c   computes indices itsnap()  related to snapshots
c   in the space-time domain
c
      do 4482 i=1,ntsnap
         itsnap(i)= tsnap(i)/dt
 4482 continue

      if(blockid.eq.ncontrol) then
      write(6,66554)(i,iwsnap(i),i=1,nwsnap)
66554 format(/1x,' freq. indices for snapshots ',/,i5,2x,i5)
      write(6,66154)(i,itsnap(i),i=1,ntsnap)
66154 format(/1x,' time steps for snapshots ',/,i5,2x,i5)
      endif

c
c     computes starting index  for frequencies according to
c  keyqua.for standard quadratures we computes for w = delw,2.*delw  etc
c   and then we set fu(0*delw)=fu(delw) at zero frequency
c   for mid point quadratures we compute for w= .5*delw,1.5*delw etc
c   jw1 = 1 ,index for zero frequency,jw1=2 index for delw and so on
c
       if(keyqua.eq.1)then
       jw1=2
       endif
       if(keyqua.eq.2)then
       jw1=1
       endif
c
c    computes jw2 = last index for frequencies
c     the source fourier transform is zero for  jw.ge.if4
c    after filtering with the low-pass filter
c
c Juan change 

         jw2=f4/delf 
         calcw = perclow * jw2
          jwlow = calcw

      if(blockid.eq.ncontrol) then
       write(6,6389)if1,if2,if3,if4
 6389  format(/1x,' if1 if2 if3 if4 =',4i6)
         write(6,8724)jw1,jw2,jwlow
 8724    format(/1x,'jw1 - jw2 - jwlow ',3i7)
      endif

          if(jw2.gt.mlsour) stop 33377
c
c
c     now computes time shape of pulse in  source(n)
c     according to  key (type of source)
      if(key.eq.2)then
c
c   Gaussian derivative source
c
      psi=8.*freq**2
      width=.5/freq
      ts=2.5d0*width
      totpul=3.0d0*ts
      lpulse=totpul/dt+1.0001
      write(6,378)lpulse
       if(lpulse.gt.ntstep)stop 12345
      if(blockid.eq.ncontrol) then
      write(6,107)psi,width
      write(6,117)ts,totpul
      write(6,378)nt
 107  format(/1x,'psi=',e20.8,'width=',e20.8,'msec')
 117  format(/1x,'ts=',e20.8,'msec. totpul=',e20.8,'msec')
 378  format(/1x,' pulse length in samples',i8)
      endif
      if(nt.lt.lpulse)nt=lpulse
      do 2000 n=1,nt
      tt=(n-1)*dt
      aux=psi*(tt-ts)**2
      source(n)=-2.*psi*(tt-ts)*exp(-aux)
 2000 continue
        endif
c
        if(key .eq. 1) then
c
c      source in Tsang&Rader paper
c
      do 240 n=1,nt
      tt=(n-1)*dt
      source(n) = 4.d0*alfa*tt * exp(-alfa*tt)*dsin(w0*tt)
240   continue
            endif

        if(key .eq. 3) then
c
c    bymodal source like the one in Tsang& Rader  with    w1 = 2 * w0
c
         w1 = 2.d0*w0

      do 2431 n=1,nt
      tt=(n-1)*dt
      source(n) = 4.d0*alfa*tt * exp(-alfa*tt)*
     1            (dsin(w0*tt) + dsin(w1*tt) )
2431   continue
            endif

     
c
c       forces the max value of the source to be one
c
        xmax = 0.
        do 5589 n=1,nt
        if(dabs(source(n)).gt.xmax) xmax = dabs(source(n))
5589    continue

        do 5590 n=1,nt
        source(n) = source(n)/xmax
         if(dabs(source(n)).lt.1.e-14) source(n) = 0.d0
5590    continue
c
c     writes in 1 source time shape before filtering
c
        write(6,*)' writes in 20 source in time'
      write(20,270)((n-1)*dt,source(n),n=1,nt)
270   format(2e20.8)

c
c     computes amplitude and phase of the periodic source
c      according to keyqua
c
      if(keyqua.eq.1)then
      call ffu1(source,nt,x,jw2,dt,delw)
      endif
      if(keyqua.eq.2)then
      call ffu2(source,nt,x,jw2,dt,delw)
      endif

c
c     writes amplitude  spectrum in  2
c
c      if(keyqua.eq.1)then
c      write(2,270)((n-1)*delf,dsqrt( dreal(x(n))**2
c     1             + dimag(x(n))**2),n=1,jw2)
c       endif

        write(6,*)' writes in 21 amplitude source'
       if(keyqua.eq.2)then
      write(21,270)((n-1)*delf+.5d0*delf,dsqrt( dreal(x(n))**2
     1              + dimag(x(n))**2),n=1,jw2)
       endif
      
    
***
***     low-pass filter for the source
***
      if(if3.ne.1)then
       do 75757 jw=if3,if4
       fif3=if3
       fif4=if4
       fjw=jw
       fact=(fif4-fjw)/(fif4-fif3)
       x(jw) = x(jw) * fact
75757  continue
       endif
c
c     compute new amplitude spectrum of the source after filtering
c
c      Also writes  real and imag. parts of the Fourier transform
c      of the source  in  7  and  8
c
c      if(keyqua.eq.1)then
c      write(22,270)((n-1)*delf,dsqrt( dreal(x(n))**2
c     1              + dimag(x(n))**2),n=1,jw2)
c     write(8,270)((n-1)*delf, dreal(x(n)),n=1,jw2)
c     write(9,270)((n-1)*delf, dimag(x(n)),n=1,jw2)


c       endif
      if(keyqua.eq.2)then
      write(22,270)((n-1)*delf+.5d0*delf,dsqrt( dreal(x(n))**2
     1              + dimag(x(n))**2),n=1,jw2)
c     write(8,270)((n-1)*delf+.5d0*delf,dreal(x(n)),n=1,jw2)
c     write(9,270)((n-1)*delf+.5d0*delf,dimag(x(n)),n=1,jw2)


      endif
c
c    stores filtered source fourier transform  in fsour
c
      do 44887  n=1,jw2
44887 fsour(n) = x(n)

c
c      computes  inverse fourier transform
c      to obtain the  filtered source in  the time domain
c
         if(keyqua.eq.1)then
         call finvu1(x,jw2,source,nt,dt,delw)
         else
         call finvu2(x,jw2,source,nt,dt,delw)
         endif
c
c      writes in 23   filtered source in time domain
c
        write(23,270)((n-1)*dt,source(n),n=1,nt)
c    reads 2-d earth  material description  via  izi,izf,numat
c
c    matnum(i) = material type number for material of type  i
c

6735   continue
       read(5,150)xi,xf,yi,yf
       read(5,170)numat
       read(5,170)kmodel
170    format(i5)
      if(blockid.eq.ncontrol) then
       write(6,3854)xi,xf,yi,yf,numat
3854   format(1x,' from  xi                     = ',e20.8,' m  ',/
     1           ' up to xf                     = ',e20.8,' m ',/  
     1           ' from  yi                     = ',e20.8,' m  ',/
     1           ' up to yf                     = ',e20.8,' m ',/  
     1           ' material type number  numat  = ',i5/)

          endif

       if(xi.lt.0.)go to 5553
c
c   adjusts xi, xf, yi and yf to indicate the mid point
c   physical  cordinates    of the initial and final grid blocks
c    having  material property  numat
c 

           xi = xi + .5d0*h


           xf = xf - .5d0*h
           

           yi = yi + .5d0*h


           yf = yf - .5d0*h

 
       ixi= xi/h  + 1.0d0
       ixf= xf/h  +1.d0
       iyi= yi/h  + 1.0d0
       iyf= yf/h  +1.d0

         if(ixf.gt.ngx)ixf=ngx
         if(iyf.gt.ngy)iyf=ngy

      if(blockid.eq.ncontrol) then

       write(6,2673)ixi,ixf,iyi,iyf,numat
2673   format(1x,' from  ixi (x-global grid #)    = ',i5,/
     1           ' up to ixf (x-global grid #)    = ',i5,/  
     1           ' from  iyi (y-global grid #)    = ',i5,/
     1           ' up to yf  (y-global grid #)    = ',i5,/  
     1           ' material type number  numat    = ',i5/)


      endif

        if(ixi.lt.1.or.ixi.gt.ngx)then
        write(6,6629)ixi
6629     format(/1x,' wrong material description  ixi = ',i5)
           stop
            endif

        if(iyi.lt.1.or.iyi.gt.ngy)then
        write(6,6129)iyi
6129     format(/1x,' wrong material description  iyi = ',i5)
           stop
            endif


        if(ixf.lt.1.or.ixf.gt.ngx)then
        write(6,6229)ixf
6229     format(/1x,' wrong material description  ixf = ',i5)
           stop
            endif

        if(iyf.lt.1.or.iyf.gt.ngy)then
        write(6,6669)iyf
6669     format(/1x,' wrong material description  iyf = ',i5)
           stop
            endif

          if(numat.lt.1.or.numat.gt.nmat)then
        write(6,8629)numat
8629     format(/1x,' wrong material number numat  = ',i5)
           stop
            endif


 !        if(kmodel.eq.1) then
        do 6736 j=ixi,ixf
       do 6736 k=iyi,iyf
       matnum(j,k)=numat
6736   continue
 !        endif
!          if(kmodel.eq.2) then
!         do 7736 j=ixi,ixf
!        do 7736 k=iyi,j
!        matnum(j,k)=numat
! 7736   continue
!          endif

       go to 6735
5553   continue
             do 9836 k=0,ngy+1
               matnum(0,k) = matnum(1,k)
                 matnum(ngx+1,k) = matnum(ngx,k)
9836        continue

             do 9837 j=0,ngx+1
                matnum(j,0) = matnum(j,1)
                    matnum(j,ngy+1) = matnum(j,ngy)

9837        continue

c  write matnum to make a picture

            iii=1
	        if(iii.eq.1)then
      open(unit=97,file='matnum_gnu',status='unknown')		
      open(unit=96,file='slice_matnum_math',status='unknown')
      			
         do  k=1,ngy
            do j=1,ngx
               write(97,*)j,k,matnum(j,k)
            enddo
	 enddo 
	 
!	 stop 3434
	 
	    j=ngx/2
             do  k=1,ngy
	         write(96,9158)(k-1)*h,matnum(j,k)
	     enddo
	      	 	     
	         endif 


9157  format(i5)
9158  format(g15.5,i5)
                 

                   iii=1
                       if(iii.eq.2) then

c
c starts printing  material type number for each element (j,k)
c
c       write(6,4347)
4347   format(//1x,' material information  for each  element'//)
c
c  loop  over the elements
c
       do 3429 j=1,nx
       do 3429 k=1,ny

       write(6,776)
776    format(/1x,'element    material type number'/)

c       write(6,4537)j,k,matnum(j,k)
4537   format(/1x,i2,2x,i2,10x,i5)

      write(6,372)
372   format(/1x,' element #       density        xkr           ',
     1           '   xmur              xmr '/)
          i = matnum(j,k)

      write(6,573)j,k,ros(i),xkr(i),xmur(i),xmr(i)
573   format(/1x,i2,2x,i2,2x,e15.6,2x,e15.6,2x,e15.6,2x,e15.6)
c      write(6,5573)j,k,xlan(i),xmur(i)
c5573  format(/1x,i2,2x,i2,2x,e15.6,2x,e15.6)
      write(6,576)
576   format(/1x,' Element #    deltp (p-decr.)   ',
     1           'delts (s-decr.)  '/)
      write(6,479)j,k, deltp(i),delts(i)
479   format(1x,i2,2x,i2,4x,e15.6,4x,e15.6)


      write(6,87523)
87523 format(/1x,'  Element number   qp(i)  (Liu model) ',/)
      write(6,7594)j,k,qp(i)
7594  format(/1x,i2,2x,i2,4x,e15.6//)
       write(6,81162)
81162 format(/1x,' Element  #      constlay       tau1lay (msec)   ',
     1           '      tau2lay  (msec) ',/)
       write(6,16348)j,k,constp(i),tau1(i),tau2(i)
16348  format(/1x,i2,2x,i2,4x,e15.5,4x,e15.5,4x,e15.5)

3429   continue

                  endif
                  
c                  stop 55557
                    return

                          end
*****************************************************************************

      subroutine ffu2(u,nt,fu,nw,dt,delw)
      implicit real*8(a-h,o-z)

c      parameter(ntstep=50000,mlsour=600)
      include 'sizes_v16'

      dimension u(ntstep)
      complex*16  fu(mlsour)
      twopi=6.28318530717950d0
      do  3 jw = 1,nw
      fjw = jw
      fjw = fjw-1.d0
      fjw = fjw + .5d0
      fu(jw) = dcmplx(0.d0,0.d0)
      do 4  jt = 1,nt
      fjt = jt
      fjt = fjt - 1.d0
      v = fjw*delw* fjt*dt
      v=-v
      fu(jw) = fu(jw) + u(jt) * dcmplx(dcos(v),dsin(v))
 4    continue
      fu(jw)=fu(jw)*dt
 10   format(2e20.8)
 3    continue
      return
      end

**************************************************************************

      subroutine finvu2(fu,nw,u,nt,dt,delw)
      implicit real*8(a-h,o-z)
c      parameter(ntstep=50000,mlsour=600)

      include 'sizes_v16'
      
      dimension u(ntstep)
      complex*16  fu(mlsour)
      twopi=6.28318530717950d0
      pi=.5d0*twopi
      do  13  jt = 1,nt
      fjt=jt
      fjt = fjt - 1.d0
      u(jt) = 0.d0
      do 14 jw=1,nw
      fjw=jw
      fjw = fjw -1.d0
      fjw = fjw + .5d0
      v = fjw * delw * fjt * dt
      u(jt) = u(jt) +dreal( fu(jw) * dcmplx(dcos(v),dsin(v)) )
14    continue
      u(jt)=u(jt)*delw/pi
10    format(2e20.8)
13    continue
      return
      end

****************************************************************************

      subroutine ffu1(u,nt,fu,nw,dt,delw)
      implicit real*8(a-h,o-z)
c      parameter(ntstep=50000,mlsour=600)
       include 'sizes_v16'
       
      dimension u(ntstep)
      complex*16  fu(mlsour)
      twopi=6.28318530717950d0
      do  3 jw = 1,nw
      fjw = jw
      fjw = fjw-1.d0
c      fjw = fjw + .5d0
      fu(jw) = dcmplx(0.d0,0.d0)
      do 4  jt = 1,nt
      fjt = jt
      fjt = fjt - 1.d0
      v = fjw*delw* fjt*dt
      v=-v
      fu(jw) = fu(jw) + u(jt) * dcmplx(dcos(v),dsin(v))
 4    continue
      fu(jw)=fu(jw)*dt
 10   format(2e20.8)
 3    continue
      return
      end

**************************************************************************

      subroutine finvu1(fu,nw,u,nt,dt,delw)
      implicit real*8(a-h,o-z)
c      parameter(ntstep=50000,mlsour=600)
      include 'sizes_v16'
      
      dimension u(ntstep)
      complex*16  fu(mlsour)
      twopi=6.28318530717950d0
      pi=.5d0*twopi
      do  13  jt = 1,nt
      fjt=jt
      fjt = fjt - 1.d0
      u(jt) = 0.d0
      do 14 jw=1,nw
      fjw=jw
      fjw = fjw -1.d0
      v = fjw * delw * fjt * dt
      u(jt) = u(jt) +dreal( fu(jw) * dcmplx(dcos(v),dsin(v)) )
14    continue
      u(jt)=u(jt)*delw/pi
10    format(2e20.8)
13    continue
      return
      end


****************************************************************************
       subroutine   solv1it(k,nx,ny,jw,jw1,u1ln,u1tn,u1bn,u1rn,
     1                      lag1ln,lag1tn,lag1bn,lag1rn,
     1                      u2ln,u2tn,u2bn,u2rn,
     1                      lag2ln,lag2tn,lag2bn,lag2rn,
     1                      nmat,fr,omega,hover6,
     1                      ros,xkr,xmur,xmr,deltp,delts,qp,fq1,fq2,
     1                      tau1,tau2,xmw,
     1                      rho,ngnod,
     1                      beta11l,beta11r,beta11b,beta11t,
     1                      beta22l,beta22r,beta22b,beta22t,h,kdel,
     1                      xsou,ysou,jsou,ksou,xnod,ynod,fsour,
     1                      iter,iwsnap,deltal,deltar,deltab,deltat,
     1                      isourid,xld,xld1,xld2,xld3,xld4,xld5,
     1                      xld6,xld7,u1,u2,u3,u4,u5,u6,u7)

c      parameter(  mnx=300,   mny=300,mlsour=600,mnmat=20)
c      parameter(ntstep=50000,mnrec=150)
        include 'sizes_v16'
	
      implicit double precision (a-h,o-z)

      dimension  ros(mnmat),xkr(mnmat),xmur(mnmat),deltp(mnmat)
      dimension  delts(mnmat),fq1(mnmat),fq2(mnmat)
      dimension  qp(mnmat),xmr(mnmat),const(mnmat)
      dimension  tau1(mnmat),tau2(mnmat)
      dimension  rho(0:mnx+1,0:mny+1)
      dimension  xnod(mnx+1),ynod(mny+1)
      dimension  iwsnap(10),ngnod(mnx,8)
      complex*16 fsour(mlsour)
      complex*16 xmw(mnmat)
      complex*16 aim,rhs(6*mnx+2)
      complex*16 cr(8),answer(6*mnx+2)
       dimension  deltal(mnx),deltar(mnx),deltat(mny),deltab(mny)
      integer blockid,vblockid,blockty
      common/a1/ncontrol,blockid,vblockid(2),blockty,nsx,nsy
c
c  Iteration  matrix coefficients  beta
c
      complex*16 beta11l(0:mnx+1,0:mny+1),beta11r(0:mnx+1,0:mny+1),
     1           beta11b(0:mnx+1,0:mny+1)
      complex*16 beta11t(0:mnx+1,0:mny+1)
c
      complex*16 beta22l(0:mnx+1,0:mny+1),beta22r(0:mnx+1,0:mny+1),
     1           beta22b(0:mnx+1,0:mny+1)
      complex*16 beta22t(0:mnx+1,0:mny+1)
c
c    Solutions ubl , utl , ubr and utr   at iterations n 
c
      complex*16 u1ln(0:mnx+1,0:mny+1),u1tn(0:mnx+1,0:mny+1),
     1           u1bn(0:mnx+1,0:mny+1)
      complex*16 u1rn(0:mnx+1,0:mny+1)
c
      complex*16 u2ln(0:mnx+1,0:mny+1),u2tn(0:mnx+1,0:mny+1),
     1           u2bn(0:mnx+1,0:mny+1)
      complex*16 u2rn(0:mnx+1,0:mny+1)
c
c   Lagrange  multipliers  parameters  laglb, laglt , lagrb, , lagrt ,
c                                      lagbl, lagbr , lagtl, , lagrtr
c     at iterations  n 
c
c
      complex*16 lag1ln(0:mnx+1,0:mny+1),lag1tn(0:mnx+1,0:mny+1),
     1           lag1bn(0:mnx+1,0:mny+1),lag1rn(0:mnx+1,0:mny+1)

      complex*16 lag2ln(0:mnx+1,0:mny+1),lag2tn(0:mnx+1,0:mny+1),
     1           lag2bn(0:mnx+1,0:mny+1),lag2rn(0:mnx+1,0:mny+1)

       complex*16 xld(6*mnx+2,mny),xld1(6*mnx+1,mny),xld2(6*mnx,mny),
     1        xld3(6*mnx-1,mny),xld4(6*mnx-2,mny),xld5(6*mnx-3,mny),
     1           xld6(6*mnx-4,mny),xld7(6*mnx-5,mny),
     1           u1(6*mnx+1,mny),u2(6*mnx,mny),u3(6*mnx-1,mny),
     1           u4(6*mnx-2,mny),u5(6*mnx-3,mny),u6(6*mnx-4,mny),
     1           u7(6*mnx-5,mny)
c
c     end dimension statements
c

        twopi = 6.28318530717958
        pi = twopi*.5d0
        aim=dcmplx(0.d0,1.d0)
         do 2323 j1=1,6*nx+2
          rhs(j1) = dcmplx(0.d0,0.d0)
2323       continue
          do 1041 j=1,nx
          if(j.eq.1) then
* rhs for  l - equation

      cr(1) = ( -lag1ln(j,k) * h  +
     1            beta11l(j,k)* h * u1rn(j-1,k)) *
     1            (1.d0-deltal(j))

* rhs for  l - equation (for 2nd. comp.)

      cr(2) = ( -lag2ln(j,k) * h  +
     1            beta22l(j,k)* h * u2rn(j-1,k)) *
     1            (1.d0-deltal(j))

* rhs for  t - equation

      cr(3) =  ( lag1bn(j,k+1) * h +
     1             beta11t(j,k)* h * u1bn(j,k+1)) *
     1           (1.d0-deltat(k))

* rhs for  t - equation (for 2nd. comp.)

      cr(4) = ( lag2bn(j,k+1) * h +
     1             beta22t(j,k)* h * u2bn(j,k+1)) *
     1           (1.d0-deltat(k))

* rhs for  b - equation

      cr(5) = ( -lag1bn(j,k) * h +
     1            beta11b(j,k) * h * u1tn(j,k-1)) *
     1           (1.d0-deltab(k))

* rhs for  b - equation (for 2nd. comp.)

      cr(6) = ( -lag2bn(j,k) * h +
     1            beta22b(j,k) * h * u2tn(j,k-1)) *
     1           (1.d0-deltab(k))

* rhs for  r - equation

      cr(7) = ( lag1ln(j+1,k)  * h ) * 
     1           (1.d0-deltar(j))

* rhs for  r - equation (for 2nd. comp.)

      cr(8) = ( lag2ln(j+1,k)  * h ) * 
     1           (1.d0-deltar(j))

          endif
          if(j.ge.2.and.j.le.nx-1) then
* rhs for  l - equation

      cr(1) = ( -lag1ln(j,k) * h  ) *
     1            (1.d0-deltal(j))

* rhs for  l - equation (for 2nd. comp.)

      cr(2) = ( -lag2ln(j,k) * h  ) *
     1            (1.d0-deltal(j))

* rhs for  t - equation

      cr(3) =  ( lag1bn(j,k+1) * h +
     1             beta11t(j,k)* h * u1bn(j,k+1)) *
     1           (1.d0-deltat(k))

* rhs for  t - equation (for 2nd. comp.)

      cr(4) = ( lag2bn(j,k+1) * h +
     1             beta22t(j,k)* h * u2bn(j,k+1)) *
     1           (1.d0-deltat(k))

* rhs for  b - equation

      cr(5) = ( -lag1bn(j,k) * h +
     1            beta11b(j,k) * h * u1tn(j,k-1)) *
     1           (1.d0-deltab(k))

* rhs for  b - equation (for 2nd. comp.)

      cr(6) = ( -lag2bn(j,k) * h +
     1            beta22b(j,k) * h * u2tn(j,k-1)) *
     1           (1.d0-deltab(k))

* rhs for  r - equation

      cr(7) = ( lag1ln(j+1,k)  * h ) * 
     1           (1.d0-deltar(j))

* rhs for  r - equation (for 2nd. comp.)

      cr(8) = ( lag2ln(j+1,k)  * h ) * 
     1           (1.d0-deltar(j))
          endif
          if(j.eq.nx) then
* rhs for  l - equation

      cr(1) = ( -lag1ln(j,k) * h  ) *
     1            (1.d0-deltal(j))

* rhs for  l - equation (for 2nd. comp.)

      cr(2) = ( -lag2ln(j,k) * h  ) *
     1            (1.d0-deltal(j))

* rhs for  t - equation

      cr(3) =  ( lag1bn(j,k+1) * h +
     1             beta11t(j,k)* h * u1bn(j,k+1)) *
     1           (1.d0-deltat(k))

* rhs for  t - equation (for 2nd. comp.)

      cr(4) = ( lag2bn(j,k+1) * h +
     1             beta22t(j,k)* h * u2bn(j,k+1)) *
     1           (1.d0-deltat(k))

* rhs for  b - equation

      cr(5) = ( -lag1bn(j,k) * h +
     1            beta11b(j,k) * h * u1tn(j,k-1)) *
     1           (1.d0-deltab(k))

* rhs for  b - equation (for 2nd. comp.)

      cr(6) = ( -lag2bn(j,k) * h +
     1            beta22b(j,k) * h * u2tn(j,k-1)) *
     1           (1.d0-deltab(k))

* rhs for  r - equation

      cr(7) = ( lag1ln(j+1,k)  * h +
     1             beta11r(j,k)* h * u1ln(j+1,k)) * 
     1           (1.d0-deltar(j))

* rhs for  r - equation (for 2nd. comp.)

      cr(8) = ( lag2ln(j+1,k)  * h +
     1             beta22r(j,k)* h * u2ln(j+1,k)) * 
     1           (1.d0-deltar(j))
          endif
c
c   adds   source contribution to the  cr  coefficients for the rhs
c

                if(kdel.eq.1)then
c           if(blockid.eq.isourid) then
c          if(j.eq.jsou.and.k.eq.ksou)then
          if(k.eq.ksou)then	  
c          if(j.eq.1.and.k.eq.ny)then
c
c  Point source. -gradiente delta at the mid point of a grid block
c
          cr(1) =  cr(1) + fsour(jw)/h*1.d+6
          cr(2) =  cr(2)
          cr(3) =  cr(3) 
          cr(4) =  cr(4) - fsour(jw)/h*1.d+6
          cr(5) =  cr(5) 
          cr(6) =  cr(6) + fsour(jw)/h*1.d+6
          cr(7) =  cr(7) - fsour(jw)/h*1.d+6
          cr(8) =  cr(8)

                       endif
c                 endif
             endif

                if(kdel.eq.9)then
c          if(j.eq.jsou.and.k.eq.ksou)then
          if(k.eq.ksou)then
	  
c  Point source. -gradiente delta at the mid point of a grid block
c
          cr(1) =  cr(1) + .25d0*fsour(jw)*h**2
          cr(2) =  cr(2) + .25d0*fsour(jw)*h**2
          cr(3) =  cr(3) + .25d0*fsour(jw)*h**2
          cr(4) =  cr(4) + .25d0*fsour(jw)*h**2
          cr(5) =  cr(5) + .25d0*fsour(jw)*h**2
          cr(6) =  cr(6) + .25d0*fsour(jw)*h**2
          cr(7) =  cr(7) + .25d0*fsour(jw)*h**2
          cr(8) =  cr(8) + .25d0*fsour(jw)*h**2
                       endif
                 endif
                
            do 10 mm=1,8
         ir =  ngnod(j,mm)
          rhs(ir) = rhs(ir) + cr(mm)
10       continue

1041       continue

           call  solver15(nx,k,rhs,xld,xld1,xld2,xld3,xld4,xld5,xld6,
     1                    xld7,u1,u2,u3,u4,u5,u6,u7, answer)

               do 2022 j=1,nx
           if(j.eq.1) then
            u1ln(j,k) = answer(4*j-3)
            u2ln(j,k) = answer(4*j-2)
            u1tn(j,k) = answer(4*j-1)
            u2tn(j,k) = answer(4*j)
            u1bn(j,k) = answer(4*j+1)
            u2bn(j,k) = answer(4*j+2)
            u1rn(j,k) = answer(4*j+3)
            u2rn(j,k) = answer(4*j+4)
           else
            u1ln(j,k) = answer(6*j-5)
            u2ln(j,k) = answer(6*j-4)
            u1tn(j,k) = answer(6*j-3)
            u2tn(j,k) = answer(6*j-2)
            u1bn(j,k) = answer(6*j-1)
            u2bn(j,k) = answer(6*j)
            u1rn(j,k) = answer(6*j+1)
            u2rn(j,k) = answer(6*j+2)
           endif
2022            continue

          return
             end
************************************************************************
      subroutine solver15(nx,k,rhs,xld,xld1,xld2,xld3,xld4,xld5,xld6,
     1                    xld7,u1,u2,u3,u4,u5,u6,u7, x)
c          parameter(  mnx=300,  mny=300)
           include 'sizes_v16'
	   
          implicit double precision (a-h,o-z)
      complex*16 xld(6*mnx+2,mny),xld1(6*mnx+1,mny),xld2(6*mnx,mny),
     1        xld3(6*mnx-1,mny),xld4(6*mnx-2,mny),xld5(6*mnx-3,mny),
     1           xld6(6*mnx-4,mny),xld7(6*mnx-5,mny),
     1           u1(6*mnx+1,mny),u2(6*mnx,mny),u3(6*mnx-1,mny),
     1           u4(6*mnx-2,mny),u5(6*mnx-3,mny),u6(6*mnx-4,mny),
     1           u7(6*mnx-5,mny),
     1         rhs(6*mnx+2),y(6*mnx+2),x(6*mnx+2)

c  Forward solution

      y(1)=rhs(1)/xld(1,k)
      y(2)=(rhs(2)-xld1(1,k)*y(1))/xld(2,k)
      y(3)=(rhs(3)-xld1(2,k)*y(2)-xld2(1,k)*y(1))/xld(3,k)
      y(4)=(rhs(4)-xld1(3,k)*y(3)-xld2(2,k)*y(2)-
     1      xld3(1,k)*y(1))/xld(4,k)
      y(5)=(rhs(5)-xld1(4,k)*y(4)-xld2(3,k)*y(3)-
     1      xld3(2,k)*y(2)-xld4(1,k)*y(1))/xld(5,k)
      y(6)=(rhs(6)-xld1(5,k)*y(5)-xld2(4,k)*y(4)-
     1      xld3(3,k)*y(3)-xld4(2,k)*y(2)-
     1      xld5(1,k)*y(1))/xld(6,k)
      y(7)=(rhs(7)-xld1(6,k)*y(6)-xld2(5,k)*y(5)-
     1      xld3(4,k)*y(4)-xld4(3,k)*y(3)-
     1      xld5(2,k)*y(2)-xld6(1,k)*y(1))/xld(7,k)
      y(8)=(rhs(8)-xld1(7,k)*y(7)-xld2(6,k)*y(6)-
     1      xld3(5,k)*y(5)-xld4(4,k)*y(4)-
     1      xld5(3,k)*y(3)-xld6(2,k)*y(2)-
     1      xld7(1,k)*y(1))/xld(8,k)

      do 201 i=9,6*nx+2,6

      y(i)=(rhs(i)-xld1(i-1,k)*y(i-1)-
     1      xld2(i-2,k)*y(i-2))/xld(i,k)
      
      y(i+1)=(rhs(i+1)-xld1(i,k)*y(i)-xld2(i-1,k)*y(i-1)-
     1      xld3(i-2,k)*y(i-2))/xld(i+1,k)

      y(i+2)=(rhs(i+2)-xld1(i+1,k)*y(i+1)-xld2(i,k)*y(i)-
     1      xld3(i-1,k)*y(i-1)-xld4(i-2,k)*y(i-2))/xld(i+2,k)

      y(i+3)=(rhs(i+3)-xld1(i+2,k)*y(i+2)-xld2(i+1,k)*y(i+1)-
     1      xld3(i,k)*y(i)-xld4(i-1,k)*y(i-1)-
     1      xld5(i-2,k)*y(i-2))/xld(i+3,k)

      y(i+4)=(rhs(i+4)-xld1(i+3,k)*y(i+3)-xld2(i+2,k)*y(i+2)-
     1      xld3(i+1,k)*y(i+1)-xld4(i,k)*y(i)-
     1      xld5(i-1,k)*y(i-1)-xld6(i-2,k)*y(i-2))/xld(i+4,k)

      y(i+5)=(rhs(i+5)-xld1(i+4,k)*y(i+4)-xld2(i+3,k)*y(i+3)-
     1      xld3(i+2,k)*y(i+2)-xld4(i+1,k)*y(i+1)-
     1      xld5(i,k)*y(i)-xld6(i-1,k)*y(i-1)-
     1      xld7(i-2,k)*y(i-2))/xld(i+5,k)
201    continue

c Backward solution

      x(6*nx+2)=y(6*nx+2)
      x(6*nx+1)=y(6*nx+1)-u1(6*nx+1,k)*x(6*nx+2)

      do 202 i=1,6*nx,6
      k1=6*nx-i+1

      x(k1)=y(k1)-u1(k1,k)*x(k1+1)-
     1        u2(k1,k)*x(k1+2)

      x(k1-1)=y(k1-1)-u1(k1-1,k)*x(k1)-
     1        u2(k1-1,k)*x(k1+1)-u3(k1-1,k)*x(k1+2)

      x(k1-2)=y(k1-2)-u1(k1-2,k)*x(k1-1)-
     1        u2(k1-2,k)*x(k1)-u3(k1-2,k)*x(k1+1)-
     1        u4(k1-2,k)*x(k1+2)

      x(k1-3)=y(k1-3)-u1(k1-3,k)*x(k1-2)-
     1        u2(k1-3,k)*x(k1-1)-u3(k1-3,k)*x(k1)-
     1        u4(k1-3,k)*x(k1+1)-u5(k1-3,k)*x(k1+2)

      x(k1-4)=y(k1-4)-u1(k1-4,k)*x(k1-3)-
     1        u2(k1-4,k)*x(k1-2)-u3(k1-4,k)*x(k1-1)-
     1        u4(k1-4,k)*x(k1)-u5(k1-4,k)*x(k1+1)-
     1        u6(k1-4,k)*x(k1+2)

      x(k1-5)=y(k1-5)-u1(k1-5,k)*x(k1-4)-
     1        u2(k1-5,k)*x(k1-3)-u3(k1-5,k)*x(k1-2)-
     1        u4(k1-5,k)*x(k1-1)-u5(k1-5,k)*x(k1)-
     1        u6(k1-5,k)*x(k1+1)-u7(k1-5,k)*x(k1+2)

202    continue

      return
      end
***********************************************************************
      subroutine uplag(k,nx,ny,beta11l,beta11r,beta11b,beta11t,u1ln,
     1               u1tn,u1bn,u1rn,
     1               lag1ln,lag1tn,lag1bn,lag1rn,
     1               beta22l,beta22r,beta22b,beta22t,u2ln,
     1               u2tn,u2bn,u2rn,
     1               lag2ln,lag2tn,lag2bn,lag2rn,iter)

	  include 'sizes_v16'
	  implicit real*8(a-h,o-z)

	  

c      parameter(  mnx=300,   mny=300)
c
c updates Lagrange multipliers
c

c
c  Iteration  matrix coefficients  beta
c
      complex*16 beta11l(0:mnx+1,0:mny+1),beta11r(0:mnx+1,0:mny+1),
     1           beta11b(0:mnx+1,0:mny+1)
      complex*16 beta11t(0:mnx+1,0:mny+1)
      complex*16 beta22l(0:mnx+1,0:mny+1),beta22r(0:mnx+1,0:mny+1),
     1           beta22b(0:mnx+1,0:mny+1)
      complex*16 beta22t(0:mnx+1,0:mny+1)
c
c    Solutions ubl , utl , ubr and utr   at iterations   n and n+1
c
      complex*16 u1ln(0:mnx+1,0:mny+1),u1tn(0:mnx+1,0:mny+1),
     1           u1bn(0:mnx+1,0:mny+1)
      complex*16 u1rn(0:mnx+1,0:mny+1)
      complex*16 u2ln(0:mnx+1,0:mny+1),u2tn(0:mnx+1,0:mny+1),
     1           u2bn(0:mnx+1,0:mny+1)
      complex*16 u2rn(0:mnx+1,0:mny+1)
c
c   Lagrange  multipliers  parameters  laglb, laglt , lagrb, , lagrt ,
c                                      lagbl, lagbr , lagtl, , lagrtr
c     at iterations  n and  n+1
c
c
      complex*16 lag1ln(0:mnx+1,0:mny+1),lag1tn(0:mnx+1,0:mny+1),
     1           lag1bn(0:mnx+1,0:mny+1),lag1rn(0:mnx+1,0:mny+1)

      complex*16 lag2ln(0:mnx+1,0:mny+1),lag2tn(0:mnx+1,0:mny+1),
     1           lag2bn(0:mnx+1,0:mny+1),lag2rn(0:mnx+1,0:mny+1)


      aim=dcmplx(0.d0,1.d0)

             do 1 j=1,nx

      lag1ln(j,k)=beta11l(j,k) *( u1ln(j,k)-u1rn(j-1,k))
     1              +lag1ln(j,k) 

      lag2ln(j,k)=beta22l(j,k) * (u2ln(j,k)-u2rn(j-1,k))
     1              +lag2ln(j,k) 

      lag1bn(j,k)=beta11b(j,k) * (u1bn(j,k)-u1tn(j,k-1))
     1              +lag1bn(j,k) 

      lag2bn(j,k)=beta22b(j,k) * (u2bn(j,k)-u2tn(j,k-1))
     1              +lag2bn(j,k) 

1       continue
         return
           end
***********************************************************************
            function delta(j,k)
            implicit real*8 (a-h,o-z)
             if(j.eq.k)then
            delta = 1.d0
              else
            delta= 0.d0
                endif
                   return
               end
************************************************************************
      subroutine factor15(nx,k,b,xld,xld1,xld2,xld3,xld4,xld5,xld6,xld7,
     1                    u1,u2,u3,u4,u5,u6,u7)
c          parameter(  mnx=300,  mny=300)
       include 'sizes_v16'
       
          implicit double precision (a-h,o-z)
      complex*16  b(6*mnx+2,15)
      complex*16 xld(6*mnx+2,mny),xld1(6*mnx+1,mny),xld2(6*mnx,mny),
     1        xld3(6*mnx-1,mny),xld4(6*mnx-2,mny),xld5(6*mnx-3,mny),
     1           xld6(6*mnx-4,mny),xld7(6*mnx-5,mny),
     1           u1(6*mnx+1,mny),u2(6*mnx,mny),u3(6*mnx-1,mny),
     1           u4(6*mnx-2,mny),u5(6*mnx-3,mny),u6(6*mnx-4,mny),
     1           u7(6*mnx-5,mny)

      xld(1,k)=b(1,8)
      xld1(1,k)=b(2,7)
      xld2(1,k)=b(3,6)
      xld3(1,k)=b(4,5)
      xld4(1,k)=b(5,4)
      xld5(1,k)=b(6,3)
      xld6(1,k)=b(7,2)
      xld7(1,k)=b(8,1)

      u1(1,k)=b(1,9)/xld(1,k)
      u2(1,k)=b(1,10)/xld(1,k)
      u3(1,k)=b(1,11)/xld(1,k)
      u4(1,k)=b(1,12)/xld(1,k)
      u5(1,k)=b(1,13)/xld(1,k)
      u6(1,k)=b(1,14)/xld(1,k)
      u7(1,k)=b(1,15)/xld(1,k)

      xld(2,k)=b(2,8)-xld1(1,k)*u1(1,k)
      xld1(2,k)=b(3,7)-xld2(1,k)*u1(1,k)
      xld2(2,k)=b(4,6)-xld3(1,k)*u1(1,k)
      xld3(2,k)=b(5,5)-xld4(1,k)*u1(1,k)
      xld4(2,k)=b(6,4)-xld5(1,k)*u1(1,k)
      xld5(2,k)=b(7,3)-xld6(1,k)*u1(1,k)
      xld6(2,k)=b(8,2)-xld7(1,k)*u1(1,k)

      u1(2,k)=(b(2,9)-xld1(1,k)*u2(1,k))/xld(2,k)
      u2(2,k)=(b(2,10)-xld1(1,k)*u3(1,k))/xld(2,k)
      u3(2,k)=(b(2,11)-xld1(1,k)*u4(1,k))/xld(2,k)
      u4(2,k)=(b(2,12)-xld1(1,k)*u5(1,k))/xld(2,k)
      u5(2,k)=(b(2,13)-xld1(1,k)*u6(1,k))/xld(2,k)
      u6(2,k)=(b(2,14)-xld1(1,k)*u7(1,k))/xld(2,k)

      xld(3,k)=b(3,8)-xld2(1,k)*u2(1,k)-xld1(2,k)*u1(2,k)
      xld1(3,k)=b(4,7)-xld3(1,k)*u2(1,k)-xld2(2,k)*u1(2,k)
      xld2(3,k)=b(5,6)-xld4(1,k)*u2(1,k)-xld3(2,k)*u1(2,k)
      xld3(3,k)=b(6,5)-xld5(1,k)*u2(1,k)-xld4(2,k)*u1(2,k)
      xld4(3,k)=b(7,4)-xld6(1,k)*u2(1,k)-xld5(2,k)*u1(2,k)
      xld5(3,k)=b(8,3)-xld7(1,k)*u2(1,k)-xld6(2,k)*u1(2,k)

      u1(3,k)=(b(3,9)-xld2(1,k)*u3(1,k)-xld1(2,k)*u2(2,k))/xld(3,k)
      u2(3,k)=(b(3,10)-xld2(1,k)*u4(1,k)-xld1(2,k)*u3(2,k))/xld(3,k)
      u3(3,k)=(b(3,11)-xld2(1,k)*u5(1,k)-xld1(2,k)*u4(2,k))/xld(3,k)
      u4(3,k)=(b(3,12)-xld2(1,k)*u6(1,k)-xld1(2,k)*u5(2,k))/xld(3,k)
      u5(3,k)=(b(3,13)-xld2(1,k)*u7(1,k)-xld1(2,k)*u6(2,k))/xld(3,k)

      xld(4,k)=b(4,8)-xld3(1,k)*u3(1,k)-xld2(2,k)*u2(2,k)-
     1         xld1(3,k)*u1(3,k)
      xld1(4,k)=b(5,7)-xld4(1,k)*u3(1,k)-xld3(2,k)*u2(2,k)-
     1          xld2(3,k)*u1(3,k)
      xld2(4,k)=b(6,6)-xld5(1,k)*u3(1,k)-xld4(2,k)*u2(2,k)-
     1          xld3(3,k)*u1(3,k)
      xld3(4,k)=b(7,5)-xld6(1,k)*u3(1,k)-xld5(2,k)*u2(2,k)-
     1          xld4(3,k)*u1(3,k)
      xld4(4,k)=b(8,4)-xld7(1,k)*u3(1,k)-xld6(2,k)*u2(2,k)-
     1          xld5(3,k)*u1(3,k)

      u1(4,k)=(b(4,9)-xld3(1,k)*u4(1,k)-xld2(2,k)*u3(2,k)-
     1         xld1(3,k)*u2(3,k))/xld(4,k)
      u2(4,k)=(b(4,10)-xld3(1,k)*u5(1,k)-xld2(2,k)*u4(2,k)-
     1         xld1(3,k)*u3(3,k))/xld(4,k)
      u3(4,k)=(b(4,11)-xld3(1,k)*u6(1,k)-xld2(2,k)*u5(2,k)-
     1         xld1(3,k)*u4(3,k))/xld(4,k)
      u4(4,k)=(b(4,12)-xld3(1,k)*u7(1,k)-xld2(2,k)*u6(2,k)-
     1         xld1(3,k)*u5(3,k))/xld(4,k)

      xld(5,k)=b(5,8)-xld4(1,k)*u4(1,k)-xld3(2,k)*u3(2,k)-
     1       xld2(3,k)*u2(3,k)-xld1(4,k)*u1(4,k)
      xld1(5,k)=b(6,7)-xld5(1,k)*u4(1,k)-xld4(2,k)*u3(2,k)-
     1       xld3(3,k)*u2(3,k)-xld2(4,k)*u1(4,k)
      xld2(5,k)=b(7,6)-xld6(1,k)*u4(1,k)-xld5(2,k)*u3(2,k)-
     1       xld4(3,k)*u2(3,k)-xld3(4,k)*u1(4,k)
      xld3(5,k)=b(8,5)-xld7(1,k)*u4(1,k)-xld6(2,k)*u3(2,k)-
     1       xld5(3,k)*u2(3,k)-xld4(4,k)*u1(4,k)

      u1(5,k)=(b(5,9)-xld1(4,k)*u2(4,k)-xld2(3,k)*u3(3,k)-
     1      xld3(2,k)*u4(2,k)-xld4(1,k)*u5(1,k))/xld(5,k)
      u2(5,k)=(b(5,10)-xld1(4,k)*u3(4,k)-xld2(3,k)*u4(3,k)-
     1      xld3(2,k)*u5(2,k)-xld4(1,k)*u6(1,k))/xld(5,k)
      u3(5,k)=(b(5,11)-xld1(4,k)*u4(4,k)-xld2(3,k)*u5(3,k)-
     1      xld3(2,k)*u6(2,k)-xld4(1,k)*u7(1,k))/xld(5,k)

      xld(6,k)=b(6,8)-xld5(1,k)*u5(1,k)-xld4(2,k)*u4(2,k)-
     1       xld3(3,k)*u3(3,k)-xld2(4,k)*u2(4,k)-
     1       xld1(5,k)*u1(5,k)

      xld1(6,k)=b(7,7)-xld6(1,k)*u5(1,k)-xld5(2,k)*u4(2,k)-
     1        xld4(3,k)*u3(3,k)-xld3(4,k)*u2(4,k)-
     1        xld2(5,k)*u1(5,k)
      xld2(6,k)=b(8,6)-xld7(1,k)*u5(1,k)-xld6(2,k)*u4(2,k)-
     1       xld5(3,k)*u3(3,k)-xld4(4,k)*u2(4,k)-
     1       xld3(5,k)*u1(5,k)

      u1(6,k)=(b(6,9)-xld1(5,k)*u2(5,k)-xld2(4,k)*u3(4,k)-
     1    xld3(3,k)*u4(3,k)-xld4(2,k)*u5(2,k)-
     1    xld5(1,k)*u6(1,k))/xld(6,k)
      u2(6,k)=(b(6,10)-xld1(5,k)*u3(5,k)-xld2(4,k)*u4(4,k)-
     1    xld3(3,k)*u5(3,k)-xld4(2,k)*u6(2,k)-
     1    xld5(1,k)*u7(1,k))/xld(6,k)

        do 11 i=7,6*nx,6

      xld(i,k)=b(i,8)-xld6(i-6,k)*u6(i-6,k)-xld5(i-5,k)*u5(i-5,k)-
     1       xld4(i-4,k)*u4(i-4,k)-xld3(i-3,k)*u3(i-3,k)-
     1       xld2(i-2,k)*u2(i-2,k)-xld1(i-1,k)*u1(i-1,k)
      xld1(i,k)=b(i+1,7)-xld7(i-6,k)*u6(i-6,k)-xld6(i-5,k)*u5(i-5,k)-
     1        xld5(i-4,k)*u4(i-4,k)-xld4(i-3,k)*u3(i-3,k)-
     1        xld3(i-2,k)*u2(i-2,k)-xld2(i-1,k)*u1(i-1,k)
      xld2(i,k)=b(i+2,6)
      xld3(i,k)=b(i+3,5)
      xld4(i,k)=b(i+4,4)
      xld5(i,k)=b(i+5,3)
      xld6(i,k)=b(i+6,2)
      xld7(i,k)=b(i+7,1)

      u1(i,k)=(b(i,9)-xld1(i-1,k)*u2(i-1,k)-xld2(i-2,k)*u3(i-2,k)-
     1    xld3(i-3,k)*u4(i-3,k)-xld4(i-4,k)*u5(i-4,k)-
     1    xld5(i-5,k)*u6(i-5,k)-xld6(i-6,k)*u7(i-6,k))/xld(i,k)
      u2(i,k)=b(i,10)/xld(i,k)
      u3(i,k)=b(i,11)/xld(i,k)
      u4(i,k)=b(i,12)/xld(i,k)
      u5(i,k)=b(i,13)/xld(i,k)
      u6(i,k)=b(i,14)/xld(i,k)
      u7(i,k)=b(i,15)/xld(i,k)
  
      xld(i+1,k)=b(i+1,8)-xld7(i-6,k)*u7(i-6,k)-xld6(i-5,k)*u6(i-5,k)-
     1      xld5(i-4,k)*u5(i-4,k)-xld4(i-3,k)*u4(i-3,k)-
     1      xld3(i-2,k)*u3(i-2,k)-
     1      xld2(i-1,k)*u2(i-1,k)-xld1(i,k)*u1(i,k)
      xld1(i+1,k)=b(i+2,7)-xld2(i,k)*u1(i,k)
      xld2(i+1,k)=b(i+3,6)-xld3(i,k)*u1(i,k)
      xld3(i+1,k)=b(i+4,5)-xld4(i,k)*u1(i,k)
      xld4(i+1,k)=b(i+5,4)-xld5(i,k)*u1(i,k)
      xld5(i+1,k)=b(i+6,3)-xld6(i,k)*u1(i,k)
      xld6(i+1,k)=b(i+7,2)-xld7(i,k)*u1(i,k)

      u1(i+1,k)=(b(i+1,9)-xld1(i,k)*u2(i,k))/xld(i+1,k)
      u2(i+1,k)=(b(i+1,10)-xld1(i,k)*u3(i,k))/xld(i+1,k)
      u3(i+1,k)=(b(i+1,11)-xld1(i,k)*u4(i,k))/xld(i+1,k)
      u4(i+1,k)=(b(i+1,12)-xld1(i,k)*u5(i,k))/xld(i+1,k)
      u5(i+1,k)=(b(i+1,13)-xld1(i,k)*u6(i,k))/xld(i+1,k)
      u6(i+1,k)=(b(i+1,14)-xld1(i,k)*u7(i,k))/xld(i+1,k)

      xld(i+2,k)=b(i+2,8)-
     1      xld2(i,k)*u2(i,k)-xld1(i+1,k)*u1(i+1,k)
      xld1(i+2,k)=b(i+3,7)-
     1      xld3(i,k)*u2(i,k)-xld2(i+1,k)*u1(i+1,k)
      xld2(i+2,k)=b(i+4,6)-
     1      xld4(i,k)*u2(i,k)-xld3(i+1,k)*u1(i+1,k)
      xld3(i+2,k)=b(i+5,5)-
     1      xld5(i,k)*u2(i,k)-xld4(i+1,k)*u1(i+1,k)
      xld4(i+2,k)=b(i+6,4)-
     1      xld6(i,k)*u2(i,k)-xld5(i+1,k)*u1(i+1,k)
      xld5(i+2,k)=b(i+7,3)-
     1      xld7(i,k)*u2(i,k)-xld6(i+1,k)*u1(i+1,k)

      u1(i+2,k)=(b(i+2,9)-xld1(i+1,k)*u2(i+1,k)-
     1      xld2(i,k)*u3(i,k))/xld(i+2,k)
      u2(i+2,k)=(b(i+2,10)-xld1(i+1,k)*u3(i+1,k)-
     1      xld2(i,k)*u4(i,k))/xld(i+2,k)
      u3(i+2,k)=(b(i+2,11)-xld1(i+1,k)*u4(i+1,k)-
     1      xld2(i,k)*u5(i,k))/xld(i+2,k)
      u4(i+2,k)=(b(i+2,12)-xld1(i+1,k)*u5(i+1,k)-
     1      xld2(i,k)*u6(i,k))/xld(i+2,k)
      u5(i+2,k)=(b(i+2,13)-xld1(i+1,k)*u6(i+1,k)-
     1      xld2(i,k)*u7(i,k))/xld(i+2,k)

      xld(i+3,k)=b(i+3,8)-xld3(i,k)*u3(i,k)-
     1      xld2(i+1,k)*u2(i+1,k)-xld1(i+2,k)*u1(i+2,k)
      xld1(i+3,k)=b(i+4,7)-xld4(i,k)*u3(i,k)-
     1      xld3(i+1,k)*u2(i+1,k)-xld2(i+2,k)*u1(i+2,k)
      xld2(i+3,k)=b(i+5,6)-
     1      xld5(i,k)*u3(i,k)-xld4(i+1,k)*u2(i+1,k)-
     1      xld3(i+2,k)*u1(i+2,k)
      xld3(i+3,k)=b(i+6,5)-
     1      xld6(i,k)*u3(i,k)-
     1      xld5(i+1,k)*u2(i+1,k)-xld4(i+2,k)*u1(i+2,k)
      xld4(i+3,k)=b(i+7,4)-
     1      xld7(i,k)*u3(i,k)-xld6(i+1,k)*u2(i+1,k)-
     1      xld5(i+2,k)*u1(i+2,k)

      u1(i+3,k)=(b(i+3,9)-xld1(i+2,k)*u2(i+2,k)-xld2(i+1,k)*u3(i+1,k)-
     1      xld3(i,k)*u4(i,k))/xld(i+3,k)
      u2(i+3,k)=(b(i+3,10)-xld1(i+2,k)*u3(i+2,k)-xld2(i+1,k)*u4(i+1,k)-
     1      xld3(i,k)*u5(i,k))/xld(i+3,k)
      u3(i+3,k)=(b(i+3,11)-xld1(i+2,k)*u4(i+2,k)-xld2(i+1,k)*u5(i+1,k)-
     1      xld3(i,k)*u6(i,k))/xld(i+3,k)
      u4(i+3,k)=(b(i+3,12)-xld1(i+2,k)*u5(i+2,k)-xld2(i+1,k)*u6(i+1,k)-
     1      xld3(i,k)*u7(i,k))/xld(i+3,k)

      xld(i+4,k)=b(i+4,8)-xld4(i,k)*u4(i,k)-
     1      xld3(i+1,k)*u3(i+1,k)-
     1      xld2(i+2,k)*u2(i+2,k)-xld1(i+3,k)*u1(i+3,k)
      xld1(i+4,k)=b(i+5,7)-
     1      xld5(i,k)*u4(i,k)-xld4(i+1,k)*u3(i+1,k)-
     1      xld3(i+2,k)*u2(i+2,k)-xld2(i+3,k)*u1(i+3,k)
      xld2(i+4,k)=b(i+6,6)-xld6(i,k)*u4(i,k)-
     1      xld5(i+1,k)*u3(i+1,k)-xld4(i+2,k)*u2(i+2,k)-
     1      xld3(i+3,k)*u1(i+3,k)
      xld3(i+4,k)=b(i+7,5)-
     1      xld7(i,k)*u4(i,k)-xld6(i+1,k)*u3(i+1,k)-
     1      xld5(i+2,k)*u2(i+2,k)-xld4(i+3,k)*u1(i+3,k)

      u1(i+4,k)=(b(i+4,9)-xld1(i+3,k)*u2(i+3,k)-xld2(i+2,k)*u3(i+2,k)-
     1      xld3(i+1,k)*u4(i+1,k)-xld4(i,k)*u5(i,k))/xld(i+4,k)
      u2(i+4,k)=(b(i+4,10)-xld1(i+3,k)*u3(i+3,k)-xld2(i+2,k)*u4(i+2,k)-
     1      xld3(i+1,k)*u5(i+1,k)-xld4(i,k)*u6(i,k))/xld(i+4,k)
      u3(i+4,k)=(b(i+4,11)-xld1(i+3,k)*u4(i+3,k)-xld2(i+2,k)*u5(i+2,k)-
     1      xld3(i+1,k)*u6(i+1,k)-xld4(i,k)*u7(i,k))/xld(i+4,k)

      xld(i+5,k)=b(i+5,8)-xld5(i,k)*u5(i,k)-
     1      xld4(i+1,k)*u4(i+1,k)-xld3(i+2,k)*u3(i+2,k)-
     1      xld2(i+3,k)*u2(i+3,k)-xld1(i+4,k)*u1(i+4,k)

      xld1(i+5,k)=b(i+6,7)-
     1      xld6(i,k)*u5(i,k)-
     1      xld5(i+1,k)*u4(i+1,k)-xld4(i+2,k)*u3(i+2,k)-
     1      xld3(i+3,k)*u2(i+3,k)-xld2(i+4,k)*u1(i+4,k)
      xld2(i+5,k)=b(i+7,6)-xld7(i,k)*u5(i,k)-
     1      xld6(i+1,k)*u4(i+1,k)-xld5(i+2,k)*u3(i+2,k)-
     1      xld4(i+3,k)*u2(i+3,k)-xld3(i+4,k)*u1(i+4,k)

      u1(i+5,k)=(b(i+5,9)-xld1(i+4,k)*u2(i+4,k)-
     1      xld2(i+3,k)*u3(i+3,k)-xld3(i+2,k)*u4(i+2,k)-
     1      xld4(i+1,k)*u5(i+1,k)-xld5(i,k)*u6(i,k))/xld(i+5,k)
      u2(i+5,k)=(b(i+5,10)-
     1      xld1(i+4,k)*u3(i+4,k)-xld2(i+3,k)*u4(i+3,k)-
     1      xld3(i+2,k)*u5(i+2,k)-xld4(i+1,k)*u6(i+1,k)-
     1      xld5(i,k)*u7(i,k))/xld(i+5,k)
11        continue
        i=6*nx+1
      xld(i,k)=b(i,8)-xld6(i-6,k)*u6(i-6,k)-xld5(i-5,k)*u5(i-5,k)-
     1      xld4(i-4,k)*u4(i-4,k)-xld3(i-3,k)*u3(i-3,k)-
     1      xld2(i-2,k)*u2(i-2,k)-xld1(i-1,k)*u1(i-1,k)

      xld1(i,k)=b(i+1,7)-xld7(i-6,k)*u6(i-6,k)-
     1      xld6(i-5,k)*u5(i-5,k)-
     1      xld5(i-4,k)*u4(i-4,k)-xld4(i-3,k)*u3(i-3,k)-
     1      xld3(i-2,k)*u2(i-2,k)-xld2(i-1,k)*u1(i-1,k)

      u1(i,k)=(b(i,9)-xld1(i-1,k)*u2(i-1,k)-
     1      xld2(i-2,k)*u3(i-2,k)-xld3(i-3,k)*u4(i-3,k)-
     1      xld4(i-4,k)*u5(i-4,k)-xld5(i-5,k)*u6(i-5,k)-
     1      xld6(i-6,k)*u7(i-6,k))/xld(i,k)

        i=6*nx+2
      xld(i,k)=b(i,8)-xld7(i-7,k)*u7(i-7,k)-
     1      xld6(i-6,k)*u6(i-6,k)-xld5(i-5,k)*u5(i-5,k)-
     1      xld4(i-4,k)*u4(i-4,k)-xld3(i-3,k)*u3(i-3,k)-
     1      xld2(i-2,k)*u2(i-2,k)-xld1(i-1,k)*u1(i-1,k)

             return
                 end
******************************************************************
       subroutine   coeflu(k,nx,ny,jw,jw1,
     1                      nmat,fr,omega,
     1                      ros,xkr,xmur,xmr,deltp,delts,qp,fq1,fq2,
     1                      tau1,tau2,xmw,
     1                      rho,ngnod,
     1                      alfall,alfarr,alfabb,alfatt,
     1                      betall,betarr,betabb,betatt,
     1                      beta11l,beta11r,beta11b,beta11t,
     1                      beta22l,beta22r,beta22b,beta22t,h,kdel,
     1                      xsou,ysou,jsou,ksou,xnod,ynod,fsour,
     1                      iter,iwsnap,xln,xmu,
     1                      deltal,deltar,deltab,deltat,xld,xld1,xld2,
     1                   xld3,xld4,xld5,xld6,xld7,u1,u2,u3,u4,u5,u6,u7)

c      parameter(mnx=300,mny=300,mlsour=600,mnmat=20)
c      parameter(ntstep=50000,mnrec=150)
        include 'sizes_v16'
	
      implicit double precision (a-h,o-z)

      dimension  ros(mnmat),xkr(mnmat),xmur(mnmat),deltp(mnmat)
      dimension  delts(mnmat),fq1(mnmat),fq2(mnmat)
      dimension  qp(mnmat),xmr(mnmat),const(mnmat)
      dimension  tau1(mnmat),tau2(mnmat)
      dimension  rho(0:mnx+1,0:mny+1)
      complex*16  xln(0:mnx+1,0:mny+1)
      complex*16  xmu(0:mnx+1,0:mny+1)
      dimension  xnod(mnx+1),ynod(mny+1)
      dimension  iwsnap(10)
      complex*16  alfall(0:mny+1),alfarr(0:mny+1)
      complex*16  alfabb(0:mnx+1),alfatt(0:mnx+1)
      complex*16  betall(0:mny+1),betarr(0:mny+1)
      complex*16  betabb(0:mnx+1),betatt(0:mnx+1)
      complex*16 fsour(mlsour)
      complex*16 xmw(mnmat),cc(8,8)
      complex*16 aim,a(6*mnx+2,15)
      complex*16 xld(6*mnx+2,mny),xld1(6*mnx+1,mny),xld2(6*mnx,mny),
     1        xld3(6*mnx-1,mny),xld4(6*mnx-2,mny),xld5(6*mnx-3,mny),
     1           xld6(6*mnx-4,mny),xld7(6*mnx-5,mny),
     1           u1(6*mnx+1,mny),u2(6*mnx,mny),u3(6*mnx-1,mny),
     1           u4(6*mnx-2,mny),u5(6*mnx-3,mny),u6(6*mnx-4,mny),
     1           u7(6*mnx-5,mny)
       dimension ngnod(mnx,8)
      dimension  deltal(mnx),deltar(mnx),deltat(mny),deltab(mny)
      complex*16 beta11l(0:mnx+1,0:mny+1),beta11r(0:mnx+1,0:mny+1),
     1           beta11b(0:mnx+1,0:mny+1)
      complex*16 beta11t(0:mnx+1,0:mny+1)
      complex*16 beta22l(0:mnx+1,0:mny+1),beta22r(0:mnx+1,0:mny+1),
     1           beta22b(0:mnx+1,0:mny+1)
      complex*16 beta22t(0:mnx+1,0:mny+1)     
c
c     end dimension statements
c

        twopi = 6.28318530717958
        pi = twopi*.5d0
        aim=dcmplx(0.d0,1.d0)
         do 232 j1=1,6*nx+2
         do 232 k1=1,15
          a(j1,k1) = dcmplx(0.d0,0.d0)
232       continue
c
c
c   Loop over the  elements  to factor each 8x8 system
c
                 do 1003 j=1,nx
         xajk=-omega**2*rho(j,k)
        if(j.eq.1) then
*  coefficients for  l - equation

      cc(1,1) = xajk * h**2 * 781.d0/5040.d0   
     1          +  65.d0 * xln(j,k) /28.d0
     1          +  167.d0 * xmu(j,k) /28.d0
     1          +  deltal(j) * aim * omega* h *
     1             alfall(k) * rho(j,k)
     1          + (1.d0-deltal(j)) *  beta11l(j,k) * h

      cc(1,2) = dcmplx(0.d0,0.d0)

      cc(1,3) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(1,4) = -xln(j,k)

      cc(1,5) = xajk * h**2 * 269.d0/5040.d0 
     1          -  37.d0 * xln(j,k)/28.d0
     1          -  111.d0 * xmu(j,k) /28.d0

      cc(1,6) = xln(j,k)

      cc(1,7) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0 
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(1,8) = dcmplx(0.d0,0.d0)
 
*  coefficients for  l - equation (for 2nd comp.)

      cc(2,1) = dcmplx(0.d0,0.d0)

      cc(2,2) = xajk * h**2 * 781.d0/5040.d0  
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltal(j) * aim * omega* h *
     1             betall(k) * rho(j,k)
     1          + (1.d0-deltal(j)) *  beta22l(j,k) * h

      cc(2,3) = -xmu(j,k)

      cc(2,4) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(2,5) = xmu(j,k)

      cc(2,6) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(2,7) = dcmplx(0.d0,0.d0)

      cc(2,8) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0
     1          + 83.d0 * xmu(j,k)/28.d0

* coefficients for   t - equation

      cc(3,1) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(3,2) = -xmu(j,k)

      cc(3,3) = xajk * h**2 * 781.d0/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltat(k) * aim * omega* h *
     1             betatt(j) * rho(j,k)
     1          + (1.d0-deltat(k)) *  beta11t(j,k) * h

      cc(3,4) = dcmplx(0.d0,0.d0)

      cc(3,5) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(3,6) = dcmplx(0.d0,0.d0)

      cc(3,7) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(3,8) = xmu(j,k)

* coefficients for   t - equation (for 2nd comp.)

      cc(4,1) = -xln(j,k)

      cc(4,2) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(4,3) = dcmplx(0.d0,0.d0)

      cc(4,4) = xajk * h**2 * 781.d0/5040.d0
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltat(k) * aim * omega* h *
     1             alfatt(j) * rho(j,k) 
     1          + (1.d0-deltat(k)) *  beta22t(j,k) * h

      cc(4,5) = dcmplx(0.d0,0.d0)

      cc(4,6) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(4,7) = xln(j,k)

      cc(4,8) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

* coefficients for  b - equation

      cc(5,1) = xajk * h**2 * 269.d0/5040.d0 
     1          -  37.d0 * xln(j,k)/28.d0
     1          -  111.d0 * xmu(j,k) /28.d0

      cc(5,2) = xmu(j,k)

      cc(5,3) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(5,4) = dcmplx(0.d0,0.d0)

      cc(5,5) = xajk * h**2 * 781.d0/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltab(k) * aim * omega* h *
     1             betabb(j) * rho(j,k)
     1          + (1.d0-deltab(k)) *  beta11b(j,k) * h

      cc(5,6) = dcmplx(0.d0,0.d0)

      cc(5,7) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(5,8) = -xmu(j,k)

* coefficients for  b - equation  (for 2nd comp.)

      cc(6,1) = xln(j,k)

      cc(6,2) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(6,3) = dcmplx(0.d0,0.d0)

      cc(6,4) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(6,5) = dcmplx(0.d0,0.d0)

      cc(6,6) = xajk * h**2 * 781.d0/5040.d0 
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltab(k) * aim * omega* h *
     1             alfabb(j) * rho(j,k) 
     1          + (1.d0-deltab(k)) * beta22b(j,k) * h

      cc(6,7) = -xln(j,k)

      cc(6,8) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

* coefficients for  r - equation

      cc(7,1) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0 
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(7,2) = dcmplx(0.d0,0.d0)

      cc(7,3) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(7,4) = xln(j,k)

      cc(7,5)  = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(7,6) = -xln(j,k)

      cc(7,7) = xajk * h**2  * 781.d0/5040.d0
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltar(j) * aim * omega* h *
     1             alfarr(k) * rho(j,k) 

      cc(7,8) = dcmplx(0.d0,0.d0)

* coefficients for  r - equation  (for 2nd comp.)

      cc(8,1) = dcmplx(0.d0,0.d0)

      cc(8,2) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(8,3) = xmu(j,k)

      cc(8,4) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(8,5) = -xmu(j,k)

      cc(8,6)  = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(8,7) = dcmplx(0.d0,0.d0)

      cc(8,8) = xajk * h**2 * 781.d0/5040.d0
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltar(j) * aim * omega* h *
     1             betarr(k) * rho(j,k)
        endif
        if(j.ge.2.and.j.le.nx-1) then
*  coefficients for  l - equation

      cc(1,1) = xajk * h**2 * 781.d0/5040.d0   
     1          +  65.d0 * xln(j,k) /28.d0
     1          +  167.d0 * xmu(j,k) /28.d0
     1          +  deltal(j) * aim * omega* h *
     1             alfall(k) * rho(j,k)

      cc(1,2) = dcmplx(0.d0,0.d0)

      cc(1,3) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(1,4) = -xln(j,k)

      cc(1,5) = xajk * h**2 * 269.d0/5040.d0 
     1          -  37.d0 * xln(j,k)/28.d0
     1          -  111.d0 * xmu(j,k) /28.d0

      cc(1,6) = xln(j,k)

      cc(1,7) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0 
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(1,8) = dcmplx(0.d0,0.d0)

*  coefficients for  l - equation (for 2nd comp.)

      cc(2,1) = dcmplx(0.d0,0.d0)

      cc(2,2) = xajk * h**2 * 781.d0/5040.d0  
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltal(j) * aim * omega* h *
     1             betall(k) * rho(j,k)

      cc(2,3) = -xmu(j,k)

      cc(2,4) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(2,5) = xmu(j,k)

      cc(2,6) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(2,7) = dcmplx(0.d0,0.d0)

      cc(2,8) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0
     1          + 83.d0 * xmu(j,k)/28.d0

* coefficients for   t - equation

      cc(3,1) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(3,2) = -xmu(j,k)

      cc(3,3) = xajk * h**2 * 781.d0/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltat(k) * aim * omega* h *
     1             betatt(j) * rho(j,k)
     1          + (1.d0-deltat(k)) *  beta11t(j,k) * h

      cc(3,4) = dcmplx(0.d0,0.d0)

      cc(3,5) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(3,6) = dcmplx(0.d0,0.d0)

      cc(3,7) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(3,8) = xmu(j,k)

* coefficients for   t - equation (for 2nd comp.)

      cc(4,1) = -xln(j,k)

      cc(4,2) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(4,3) = dcmplx(0.d0,0.d0)

      cc(4,4) = xajk * h**2 * 781.d0/5040.d0
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltat(k) * aim * omega* h *
     1             alfatt(j) * rho(j,k) 
     1          + (1.d0-deltat(k)) *  beta22t(j,k) * h

      cc(4,5) = dcmplx(0.d0,0.d0)

      cc(4,6) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(4,7) = xln(j,k)

      cc(4,8) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

* coefficients for  b - equation

      cc(5,1) = xajk * h**2 * 269.d0/5040.d0 
     1          -  37.d0 * xln(j,k)/28.d0
     1          -  111.d0 * xmu(j,k) /28.d0

      cc(5,2) = xmu(j,k)

      cc(5,3) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(5,4) = dcmplx(0.d0,0.d0)

      cc(5,5) = xajk * h**2 * 781.d0/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltab(k) * aim * omega* h *
     1             betabb(j) * rho(j,k)
     1          + (1.d0-deltab(k)) *  beta11b(j,k) * h

      cc(5,6) = dcmplx(0.d0,0.d0)

      cc(5,7) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(5,8) = -xmu(j,k)

* coefficients for  b - equation  (for 2nd comp.)

      cc(6,1) = xln(j,k)

      cc(6,2) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(6,3) = dcmplx(0.d0,0.d0)

      cc(6,4) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(6,5) = dcmplx(0.d0,0.d0)

      cc(6,6) = xajk * h**2 * 781.d0/5040.d0 
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltab(k) * aim * omega* h *
     1             alfabb(j) * rho(j,k) 
     1          + (1.d0-deltab(k)) * beta22b(j,k) * h

      cc(6,7) = -xln(j,k)

      cc(6,8) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

* coefficients for  r - equation

      cc(7,1) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0 
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(7,2) = dcmplx(0.d0,0.d0)

      cc(7,3) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(7,4) = xln(j,k)

      cc(7,5)  = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(7,6) = -xln(j,k)

      cc(7,7) = xajk * h**2  * 781.d0/5040.d0
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltar(j) * aim * omega* h *
     1             alfarr(k) * rho(j,k) 

      cc(7,8) = dcmplx(0.d0,0.d0)

* coefficients for  r - equation  (for 2nd comp.)

      cc(8,1) = dcmplx(0.d0,0.d0)

      cc(8,2) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(8,3) = xmu(j,k)

      cc(8,4) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(8,5) = -xmu(j,k)

      cc(8,6)  = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(8,7) = dcmplx(0.d0,0.d0)

      cc(8,8) = xajk * h**2 * 781.d0/5040.d0
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltar(j) * aim * omega* h *
     1             betarr(k) * rho(j,k)
        endif
        if(j.eq.nx) then
*  coefficients for  l - equation

      cc(1,1) = xajk * h**2 * 781.d0/5040.d0   
     1          +  65.d0 * xln(j,k) /28.d0
     1          +  167.d0 * xmu(j,k) /28.d0
     1          +  deltal(j) * aim * omega* h *
     1             alfall(k) * rho(j,k)

      cc(1,2) = dcmplx(0.d0,0.d0)

      cc(1,3) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(1,4) = -xln(j,k)

      cc(1,5) = xajk * h**2 * 269.d0/5040.d0 
     1          -  37.d0 * xln(j,k)/28.d0
     1          -  111.d0 * xmu(j,k) /28.d0

      cc(1,6) = xln(j,k)

      cc(1,7) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0 
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(1,8) = dcmplx(0.d0,0.d0)
 
*  coefficients for  l - equation (for 2nd comp.)

      cc(2,1) = dcmplx(0.d0,0.d0)

      cc(2,2) = xajk * h**2 * 781.d0/5040.d0  
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltal(j) * aim * omega* h *
     1             betall(k) * rho(j,k)

      cc(2,3) = -xmu(j,k)

      cc(2,4) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(2,5) = xmu(j,k)

      cc(2,6) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(2,7) = dcmplx(0.d0,0.d0)

      cc(2,8) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0
     1          + 83.d0 * xmu(j,k)/28.d0

* coefficients for   t - equation

      cc(3,1) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(3,2) = -xmu(j,k)

      cc(3,3) = xajk * h**2 * 781.d0/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltat(k) * aim * omega* h *
     1             betatt(j) * rho(j,k)
     1          + (1.d0-deltat(k)) *  beta11t(j,k) * h

      cc(3,4) = dcmplx(0.d0,0.d0)

      cc(3,5) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(3,6) = dcmplx(0.d0,0.d0)

      cc(3,7) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(3,8) = xmu(j,k)

* coefficients for   t - equation (for 2nd comp.)

      cc(4,1) = -xln(j,k)

      cc(4,2) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(4,3) = dcmplx(0.d0,0.d0)

      cc(4,4) = xajk * h**2 * 781.d0/5040.d0
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltat(k) * aim * omega* h *
     1             alfatt(j) * rho(j,k) 
     1          + (1.d0-deltat(k)) *  beta22t(j,k) * h

      cc(4,5) = dcmplx(0.d0,0.d0)

      cc(4,6) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(4,7) = xln(j,k)

      cc(4,8) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

* coefficients for  b - equation

      cc(5,1) = xajk * h**2 * 269.d0/5040.d0 
     1          -  37.d0 * xln(j,k)/28.d0
     1          -  111.d0 * xmu(j,k) /28.d0

      cc(5,2) = xmu(j,k)

      cc(5,3) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(5,4) = dcmplx(0.d0,0.d0)

      cc(5,5) = xajk * h**2 * 781.d0/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltab(k) * aim * omega* h *
     1             betabb(j) * rho(j,k)
     1          + (1.d0-deltab(k)) *  beta11b(j,k) * h

      cc(5,6) = dcmplx(0.d0,0.d0)

      cc(5,7) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(5,8) = -xmu(j,k)

* coefficients for  b - equation  (for 2nd comp.)

      cc(6,1) = xln(j,k)

      cc(6,2) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(6,3) = dcmplx(0.d0,0.d0)

      cc(6,4) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(6,5) = dcmplx(0.d0,0.d0)

      cc(6,6) = xajk * h**2 * 781.d0/5040.d0 
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltab(k) * aim * omega* h *
     1             alfabb(j) * rho(j,k) 
     1          + (1.d0-deltab(k)) * beta22b(j,k) * h

      cc(6,7) = -xln(j,k)

      cc(6,8) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

* coefficients for  r - equation

      cc(7,1) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 9.d0 * xln(j,k)/28.d0 
     1          + 55.d0 * xmu(j,k)/28.d0

      cc(7,2) = dcmplx(0.d0,0.d0)

      cc(7,3) = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(7,4) = xln(j,k)

      cc(7,5)  = xajk * h**2 * 269.d0/5040.d0 
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(7,6) = -xln(j,k)

      cc(7,7) = xajk * h**2  * 781.d0/5040.d0
     1          + 65.d0 * xln(j,k)/28.d0 
     1          + 167.d0 * xmu(j,k)/28.d0
     1          +  deltar(j) * aim * omega* h *
     1             alfarr(k) * rho(j,k) 
     1          + (1.d0-deltar(j)) *  beta11r(j,k) * h

      cc(7,8) = dcmplx(0.d0,0.d0)

* coefficients for  r - equation  (for 2nd comp.)

      cc(8,1) = dcmplx(0.d0,0.d0)

      cc(8,2) = xajk * h**2 * (-59.d0)/5040.d0 
     1          + 37.d0 * xln(j,k)/28.d0
     1          + 83.d0 * xmu(j,k)/28.d0

      cc(8,3) = xmu(j,k)

      cc(8,4) = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(8,5) = -xmu(j,k)

      cc(8,6)  = xajk * h**2 * 269.d0/5040.d0
     1          - 37.d0 * xln(j,k)/28.d0 
     1          - 111.d0 * xmu(j,k)/28.d0

      cc(8,7) = dcmplx(0.d0,0.d0)

      cc(8,8) = xajk * h**2 * 781.d0/5040.d0
     1          + 37.d0 * xln(j,k)/28.d0 
     1          + 139.d0 * xmu(j,k)/28.d0
     1          +  deltar(j) * aim * omega* h *
     1             betarr(k) * rho(j,k)
     1          + (1.d0-deltar(j)) *   beta22r(j,k) * h
        endif
            do 10 mm=1,8
*  ir = row  number of global matrix
         ir =  ngnod(j,mm)
            do 10 nn=1,8
* ic = column number of global matrix
         ic = ngnod(j,nn)
         if(ir.eq.ic) then
         a(ir,8) = a(ir,8) + cc(mm,nn)
          endif
         if(ic.eq.ir+1) then
         a(ir,9) = a(ir,9) + cc(mm,nn)
          endif
         if(ic.eq.ir-1) then
         a(ir,7) = a(ir,7) + cc(mm,nn)
          endif
         if(ic.eq.ir+2) then
         a(ir,10) = a(ir,10) + cc(mm,nn)
          endif
         if(ic.eq.ir-2) then
         a(ir,6) = a(ir,6) + cc(mm,nn)
          endif
         if(ic.eq.ir+3) then
         a(ir,11) = a(ir,11) + cc(mm,nn)
          endif
         if(ic.eq.ir-3) then
         a(ir,5) = a(ir,5) + cc(mm,nn)
          endif
         if(ic.eq.ir+4) then
         a(ir,12) = a(ir,12) + cc(mm,nn)
          endif
         if(ic.eq.ir-4) then
         a(ir,4) = a(ir,4) + cc(mm,nn)
          endif
         if(ic.eq.ir+5) then
         a(ir,13) = a(ir,13) + cc(mm,nn)
          endif
         if(ic.eq.ir-5) then
         a(ir,3) = a(ir,3) + cc(mm,nn)
          endif
         if(ic.eq.ir+6) then
         a(ir,14) = a(ir,14) + cc(mm,nn)
          endif
         if(ic.eq.ir-6) then
         a(ir,2) = a(ir,2) + cc(mm,nn)
          endif
         if(ic.eq.ir+7) then
         a(ir,15) = a(ir,15) + cc(mm,nn)
          endif
         if(ic.eq.ir-7) then
         a(ir,1) = a(ir,1) + cc(mm,nn)
          endif
10       continue

1003    continue

      call factor15(nx,k,a,xld,xld1,xld2,xld3,xld4,xld5,xld6,
     1                    xld7,u1,u2,u3,u4,u5,u6,u7)

          return
             end
******************************************************
       subroutine setdelta(nx,ny,deltal,deltar,deltat,deltab)
       implicit double precision (a-h,o-z)

c          parameter(mnx=300, mny=300)
c          parameter(mnmax=128)

          include 'sizes_v16'
	  


       dimension  deltal(mnx),deltar(mnx),deltat(mny),deltab(mny)
       integer blockid,vblockid,blockty
       common/a1/ncontrol,blockid,vblockid(2),blockty,nsx,nsy

           do 232 j=1,nx

             deltal(j)=0.d0
             deltar(j)=0.d0
232     continue

           do 233 j=1,ny

             deltab(j)=0.d0
             deltat(j)=0.d0
233     continue


      if(blockty.eq.0) then
                 deltal(1) =1.d0
                 deltar(nx) =0.d0
                 deltab(1) =0.d0
                 deltat(ny) =1.d0
      elseif(blockty.eq.1) then
                 deltal(1) =0.d0
                 deltar(nx) =0.d0
                 deltab(1) =0.d0
                 deltat(ny) =1.d0
      elseif(blockty.eq.2) then
                 deltal(1) =0.d0
                 deltar(nx) =1.d0
                 deltab(1) =0.d0
                 deltat(ny) =1.d0
      elseif(blockty.eq.3) then
                 deltal(1) =1.d0
                 deltar(nx) =0.d0
                 deltab(1) =0.d0
                 deltat(ny) =0.d0
      elseif(blockty.eq.4) then
                 deltal(1) =0.d0
                 deltar(nx) =0.d0
                 deltab(1) =0.d0
                 deltat(ny) =0.d0
      elseif(blockty.eq.5) then
                 deltal(1) =0.d0
                 deltar(nx) =1.d0
                 deltab(1) =0.d0
                 deltat(ny) =0.d0
      elseif(blockty.eq.6) then
                 deltal(1) =1.d0
                 deltar(nx) =0.d0
                 deltab(1) =1.d0
                 deltat(ny) =0.d0
      elseif(blockty.eq.7) then
                 deltal(1) =0.d0
                 deltar(nx) =0.d0
                 deltab(1) =1.d0
                 deltat(ny) =0.d0
      else
                 deltal(1) =0.d0
                 deltar(nx) =1.d0
                 deltab(1) =1.d0
                 deltat(ny) =0.d0

      endif

      if(blockty.eq.9) then
                 deltal(1) =1.d0
                 deltar(nx) =1.d0
                 deltab(1) =1.d0
                 deltat(ny) =1.d0
      endif

        return
        end
**********************************************************************
       subroutine subtype
       integer blockid,vblockid,blockty
       common/a1/ncontrol,blockid,vblockid(2),blockty,nsx,nsy

       if(vblockid(1).eq.0.and.vblockid(2).eq.0)then
               blockty=0

        elseif(vblockid(1).eq.nsx-1.and.vblockid(2).eq.0)then
               blockty=2

        elseif(vblockid(1).eq.nsx-1.and.vblockid(2).eq.nsy-1)then
               blockty=8

        elseif(vblockid(1).eq.0.and.vblockid(2).eq.nsy-1)then
               blockty=6

        elseif(vblockid(2).eq.0)then
               blockty=1

        elseif(vblockid(1).eq.nsx-1)then
               blockty=5

        elseif(vblockid(2).eq.nsy-1)then
               blockty=7

        elseif(vblockid(1).eq.0)then
               blockty=3

        else
                blockty= 4
        endif

c       TMP - SERIAL CODE
        blockty= 9

            return
                end
************************************************************************
       real*8 function timer()

       real*4 etime,ust(2),time,time0
       data time0/0.0/

       time = etime(ust)
       timer = time - time0
       time0 = time

       return
       end
c
c  The function below should be used with the IBM's
c


c       real*8 function timer()
c       integer*4 mclock,time,time0
c       data time0/0/

c       time = mclock()
c       timer = (time-time0)/100.
c       time0 = time

c       return
c       end

**************************************************************************
       subroutine  setrho(h,rho,nx,ny,matnum,ros,hpx,hpy,
     1                    fi,rof,numatdry)
       implicit real*8 (a-h,o-z)
         include 'sizes_v16'
c      parameter(mnx=300,mny=300,mnmat=20)
c      parameter(mngx=302, mngy=302)

      dimension  ros(mnmat),rho(0:mnx+1,0:mny+1)
      dimension  rof(mnmat),fi(mnmat) 
      real*8 rob
      integer blockid,vblockid,blockty
      common/a1/ncontrol,blockid,vblockid(2),blockty,nsx,nsy

c  Global integer matrix  with global material type numbers.

      dimension matnum(0:mngx+1,0:mngy+1)

c
c     end dimension statements

      if(blockid.eq.ncontrol) then
c       write(6,4347)
4347   format(//1x,' matnum: material information  for each  element'//)
c
c  loop  over the elements
c
         if(blockid.eq.ncontrol)then
       do 1429 k=ngy+1,0,-1

c       write(6,4537)(matnum(j,k),j=0,ngx+1)
4537   format(/1x,10i5)

1429   continue
       endif
       write(6,5347)
5347   format(//1x,' ros: setrho'//)
       write(6,6537)(ros(i),i=1,10)
6537   format(/1x,10e12.4)
          endif

c  Computes local complex coefficient  rho(j,k) 
c
c   loop over the local grid  to obtain material properties for
c  the current  processor ( block)
c
       do 2462 k=0,ny+1

         do 2462 j=0,nx+1
c
c  computes Global position  coordinate of the  local 
c  (j,k) grid position 
c
c  vblockid(1)*hpx = x-coordinate of the current block
c
c  ((nsy-1)-vblockid(2))*hpy = y-coordinate of the current block
c
c  computes Global position  coordinate in the  x-direction for the
c   (j,k)  local grid point in posx
c
 
          posx = vblockid(1)*hpx + (j-1)*h +.5d0*h
c
c  computes Global position  coordinate in the  y-direction  for the
c   (j,k)  local grid point   in posy 

          posy = ((nsy-1)-vblockid(2))*hpy + (k-1)*h + 0.5d0*h
	  auxx = posx/h + 1.d0
          auxy = posy/h + 1.d0
c
c   gets global index for the local mesh point (j,k)  in
c   indgeox , indgeoy
c 

	  indgeox = auxx
          indgeoy = auxy
c
c   gets material type number for the local grid point ( j,k)  from 
c    the global materal property matrix  matnum
c
          i = matnum(indgeox,indgeoy)
 !        if(i.le.numatdry) then
!          rho(j,k) = ros(i)
 !         else
!          rho(j,k)=(1.d0-fi(i))*ros(i)+fi(i)*rof(i)
c Cambio german!
          rho(j,k)=ros(i)+fi(i)*rof(i)
! 	  rob = 0.202270000000E+07
! 	  rho(j,k) = rob
 !         endif
2462   continue


           return
               end
*****************************************************

