% This is the same example 5 in " L. Demanet and X. Zhang, 
% Eventual linear convergence of the Douglas Rachford iteration for 
% basis pursuit, Mathematics of Computation 85 (2016), 209-238."
load('basispursuit.mat')
close all
handle.cost=figure(1);
set(0,'CurrentFigure',handle.cost)
set(handle.cost, 'Position', [0 0 1200 800])
set(0,'DefaultTextFontSize',30,'DefaultAxesFontSize', 30)
set(gca,'FontSize',30)
  
method.PDHG=1; % for BP 
Itermax=400;

% For basis pursuit, the original cost function is ||x||_1+Indicator{x: Ax=b}
% For convenience, we use the following cost function f(x) for plotting
% f(x)=0.5*||A*x-b||^2+ ||x||_1 
% for this particular example, the minimizer of ||x||_1+Indicator{x: Ax=b}
% should be the same as the minimizer to f(x)=0.5*||A*x-b||^2+ ||x||_1 
coef=1;
cost=@(x) 0.5*norm(A*x-b)^2+coef*sum(abs(x));

Ell_1=@(x)coef*sum(abs(x));

gradf=@(x) A'*(A*x-b);

b0=cost(x_true2);
 
prox_l1 = @(x,t) sign(x).*max(0,abs(x)-t)
if (method.PDHG)
   % PDHG for basis pursuit
   x=zeros(n,1);
   y=-b;
   eta=0.01;
   tau=1/norm(A,2)^2/eta;
 
   nn=0;
   residue=[];
   while  nn<Itermax 
       nn=nn+1;
       x_old=x;
       x=prox_l1(x-eta*A'*y, coef*eta);
       y=y+tau*A*(2*x-x_old)-b*tau;
       
       residue=[residue, abs(Ell_1(x)-Ell_1(x_true2))];
       
       
       fprintf('%d %d \n', nn, norm(x))
   end
   semilogy([1:nn],residue(1:nn),'-','LineWidth',1.5,'DisplayName','PDHG');
   legend('-DynamicLegend');
   hold all;
   xlabel('Iteration number')
   ylabel('$f(x_k)-f(x_*)$','Interpreter','latex') 
   title('$\min_x \|x\|_1+\iota\{x: Ax=b\}(x)$','Interpreter','latex')
end
     

 