% This is a quick comparison for minimizing ||x||_1+0.5*||Ax-b||^2
load('lasso.mat')
% loading a specific problem with A being a 40 by 1000 matrix
% and the minimizer is x_true_lasso 

 
handle.cost=figure(1);
set(0,'CurrentFigure',handle.cost)
set(handle.cost, 'Position', [0 0 1200 800])
set(0,'DefaultTextFontSize',30,'DefaultAxesFontSize', 30)
set(gca,'FontSize',30)
% compare ISTA with FISTA
 
method.FISTA=1;
method.ISTA=1;
 
Itermax=400;
% cost functions is f(x)=0.5*||A*x-b||^2+coef*||x||_1 
coef=1;
cost=@(x) 0.5*norm(A*x-b)^2+coef*sum(abs(x));

Ell_1=@(x)coef*sum(abs(x));

gradf=@(x) A'*(A*x-b);

 
b1=cost(x_true_lasso);
 
prox_l1 = @(x,t) sign(x).*max(0,abs(x)-t)
 


 


if (method.ISTA)
   % proximal gradient
   x=zeros(n,1);
   
   eta=0.001;
 
   nn=0;
   residue=[];
   while  nn<Itermax 
       nn=nn+1;
       x=prox_l1(x-eta*gradf(x),eta*coef);
       residue=[residue, cost(x)-b1];
       fprintf('%d %d \n', nn, norm(x))
   end
   semilogy([1:nn],residue(1:nn),'-.','LineWidth',1.5, 'DisplayName','ISTA (Proximal Gradient)');
   legend('-DynamicLegend');
   hold all;
   xlabel('Iteration number')
   ylabel('$F(x_k)-F(x_*)$','Interpreter','latex')
   title('$\min_x \|x\|_1+\|Ax-b\|^2$','Interpreter','latex')
end


if (method.FISTA)
   % accelerated proximal gradient
   x=zeros(n,1);
   y=x;
   eta=0.001; % note: 1/norm(A)^2 ~= 7e-4
   nn=0;
   residue=[];
   t=1;
   while  nn<Itermax
       nn=nn+1;
       t_old=t;
       t=(sqrt(t^2*4+1)+1)/2;
       
       x_old=x;
       x=prox_l1(y-eta*gradf(y),eta*coef);
       y=x+ (t_old-1)/t*(x-x_old);
       residue=[residue, cost(x)-b1];
   end
   semilogy([1:nn],residue(1:nn),'o','LineWidth',1.5, 'DisplayName','FISTA (Fast Proximal Gradient)');
   legend('-DynamicLegend');
   hold all;
   xlabel('Iteration number')
   ylabel('$F(x_k)-F(x_*)$','Interpreter','latex')
   title('$\min_x \|x\|_1+\|Ax-b\|^2$','Interpreter','latex')
end
 


 
 